/* Copyright 2021-2023 Ethan Halsall. This file is part of wasm-audio-decoders. https://github.com/eshaz/wasm-audio-decoders */
var t,s;t=this,s=function(t,s){function e(){const t=Uint8Array,s=Float32Array;e.t||Object.defineProperties(e,{t:{value:new WeakMap},u:{value(t,s){e.t.set(t,Promise.resolve(s))}},U:{value(t,s){let i=e.t.get(t);return i||(s?i=WebAssembly.compile(e.M(s)):(s=t.L,i=e.A(s).then((t=>WebAssembly.compile(t)))),e.t.set(t,i)),i}},P:{value(t,e){let i=new s(e),r=0,n=0;for(;r<t.length;)i.set(t[r],n),n+=t[r++].length;return i}},B:{value:(t,s,e,i,r)=>({C:t,channelData:s,samplesDecoded:e,sampleRate:i,bitDepth:r})},T:{value(t,s,i,r,n,h){let o,a,l=[];for(o=0;o<i;o++){const t=[];for(a=0;a<s.length;)t.push(s[a++][o]||[]);l.push(e.P(t,r))}return e.B(t,l,r,n,h)}},O:{value:(()=>{let t,s,e,i=new Int32Array(256);for(t=0;t<256;t++){for(e=t<<24,s=8;s>0;--s)e=2147483648&e?e<<1^79764919:e<<1;i[t]=e}return i})()},M:{value(s){let i,r,n,h=new t(s.length),o=parseInt(s.substring(11,13),16),a=256-o,l=!1,c=0,u=21,d=4294967295;for(;u<s.length;)r=s.charCodeAt(u++),61!==r||l?(l&&(l=!1,r-=64),h[c]=r<o&&r>0?r+a:r-o,d=d<<8^e.O[255&(d>>24^h[c++])]):l=!0;for(i=0;i<=8;i+=2)n|=parseInt(s.substring(13+i,15+i),16)<<4*i;if(n!==d)throw Error("WASM string decode failed crc32 validation");return h.subarray(0,c)}},A:{value(s){return s=e.M(s),new Promise((i=>{const r=String.raw`dynEncode0114db91da9bu*ttt$#U¤¤U¤¤3yzzss|yusvuyÚ&4<054<,5T44^T44<(6U~J(44< ~A544U~6J0444545 444J0444J,4U4UÒ7U454U4Z4U4U^/6545T4T44BU~64CU~O4U54U~5 U5T4B4Z!4U~5U5U5T4U~6U4ZTU5U5T44~4O4U2ZTU5T44Z!4B6T44U~64B6U~O44U~4O4U~54U~5 44~C4~54U~5 44~5454U4B6Ub!444~UO4U~5 U54U4ZTU#44U$464<4~B6^4<444~U~B4U~54U544~544~U5 µUä#UJUè#5TT4U0ZTTUX5U5T4T4Uà#~4OU4U $~C4~54U~5 T44$6U\!TTT4UaT4<6T4<64<Z!44~4N4<U~5 4UZ!4U±_TU#44UU6UÔ~B$544$6U\!4U6U¤#~B44Uä#~B$~64<6_TU#444U~B~6~54<Y!44<_!T4Y!4<64~444~AN44<U~6J4U5 44J4U[!U#44UO4U~54U~5 U54 7U6844J44J 4UJ4UJ04VK(44<J44<J$4U´~54U~5 4U¤~5!TTT4U$5"U5TTTTTTT4U$"4VK,U54<(6U~64<$6_!4< 64~6A54A544U~6#J(U54A4U[!44J(44#~A4U6UUU[!4464~64_!4<64~54<6T4<4]TU5 T4Y!44~44~AN4U~54U~54U5 44J(44J UÄA!U5U#UôJU"UÔJU#UÔ"JU#U´"JT4U´ZTU5T4UôZTU5T4UDZTU5T4U$[T44~UO4U~5 UÔUô4U~U´$.U5T4UP[T4U~4~UO4U~5 U#<U#<4U~U2$.UÄUN 44 ~UO4U~5 44!~UO4U~5 4U~4~UO4U~5 44J44J(U5 44U¤~J@44Uä~J<44UD~J844U~J44U$54U$5U54U$54U1^4U1^!4U~54U~5U54U~6U4U^/65T4T4U$54U~4BU~4O4U54U~5 UU'464U'_/54UU~5T4T4U~4BU~UO4U54U~5 U54Uä~4U¤~4U~U'$!44~5U5T44\T44U<~$6U\!4U#aT4U~4U~4O4U~5 U5U5U5TTT4U$"4YTU5 4U4~C5U5 U5U5444$4~64~\TU5 4U~4U~5T4Y!44O4U~54U~54U5 4CYTU5 4Uä~4U¤~4U~4$6TU54U\!44Bæ4Bä~[!4U~4UD~4U~4U~4$6TU54U\!44B4B~[!44U<~4U4~$5 4U"U#$544"Y!454U^!44<J44<(J454U~84­UN!#%'+/37?GOWgw·×÷Uä;U9$%& !"#`;e.U(e,r).then((t=>WebAssembly.instantiate(t,{}))).then((({exports:e})=>{const r=new Map(Object.entries(e)),n=r.get("puff"),h=r.get("memory").buffer,o=new t(h),a=new DataView(h);let l=r.get("__heap_base");const c=s.length,u=l;l+=4,a.setInt32(u,c,!0);const d=l;l+=c,o.set(s,d);const U=l;l+=4,a.setInt32(U,o.byteLength-l,!0),n(l,U,d,u),i(o.slice(l,l+a.getInt32(U,!0)))}))}))}}}),Object.defineProperty(this,"L",{enumerable:!0,get:()=>this.$}),this.v=(t,s,e)=>{let i=[],r=0;for(;r<s;)i.push(t.slice(r*e,r++*e+e));return i},this.S=(t,s,e=!0)=>{const i=this.$.H(s.BYTES_PER_ELEMENT*t);return e&&this.D.add(i),{K:i,R:t,G:new s(this.$.N,i,t)}},this.free=()=>{this.D.forEach((t=>{this.$.free(t)})),this.D.clear()},this.V=t=>{const s=[],e=new Uint8Array(this.$.N);for(let i=e[t];0!==i;i=e[++t])s.push(i);return String.fromCharCode.apply(null,s)},this.J=(t,s,e,i,r,n)=>{t.push({message:s,frameLength:e,frameNumber:i,inputBytes:r,outputSamples:n})},this.instantiate=(t,s)=>(s&&e.u(t,s),this.$=new t(e).instantiate(),this.D=new Set,this.$.ready.then((()=>this)))}class i extends((()=>globalThis.Worker||s)()){constructor(t,s,i,r){e.t||new e;let n=e.t.get(i);if(!n){let t,s="text/javascript",h=`'use strict';(${""+((t,s,e)=>{let i,r,n=new Promise((t=>{r=t}));self.onmessage=({data:{id:h,command:o,data:a}})=>{let l,c=n,u={id:h};"init"===o?(Object.defineProperties(t,{W:{value:s},X:{value:e},I:{value:a.I},Z:{value:!0}}),i=new t(a.options),r()):"free"===o?i.free():"ready"===o?c=c.then((()=>i.ready)):"reset"===o?c=c.then((()=>i.reset())):(Object.assign(u,i[o](Array.isArray(a)?a.map((t=>new Uint8Array(t))):new Uint8Array(a))),l=u.channelData?u.channelData.map((t=>t.buffer)):[]),c.then((()=>self.postMessage(u,l)))}})})(${i}, ${e}, ${r})`;try{t=void 0!==process.versions.node}catch{}n=t?`data:${s};base64,${Buffer.from(h).toString("base64")}`:URL.createObjectURL(new Blob([h],{type:s})),e.t.set(i,n)}super(n,{name:s}),this.F=Number.MIN_SAFE_INTEGER,this.Y=new Map,this.onmessage=({data:t})=>{const{id:s,...e}=t;this.Y.get(s)(e),this.Y.delete(s)},new r(e).U().then((s=>{this._("init",{I:s,options:t})}))}async _(t,s){return new Promise((e=>{this.postMessage({command:t,id:this.F,data:s}),this.Y.set(this.F++,e)}))}get ready(){return this._("ready")}async free(){await this._("free").finally((()=>{this.terminate()}))}async reset(){await this._("reset")}}const r=(t,s)=>{Object.defineProperty(t,"name",{value:s})},n=Symbol,h=(()=>{const t="left",s="center",e="right";return["","front ","side ","rear "].map((i=>[[t,e],[t,e,s],[t,s,e],[s,t,e],[s]].flatMap((t=>t.map((t=>i+t)).join(", ")))))})(),o="LFE",a="monophonic (mono)",l="stereo",c="surround",u=(t,...s)=>`${[a,l,"linear "+c,"quadraphonic","5.0 "+c,"5.1 "+c,"6.1 "+c,"7.1 "+c][t-1]} (${s.join(", ")})`,d=[a,u(2,h[0][0]),u(3,h[0][2]),u(4,h[1][0],h[3][0]),u(5,h[1][2],h[3][0]),u(6,h[1][2],h[3][0],o),u(7,h[1][2],h[2][0],h[3][4],o),u(8,h[1][2],h[2][0],h[3][0],o)],U=48e3,f=44100,p=32e3,M=24e3,y=22050,m=16e3,L=8e3,b="absoluteGranulePosition",g="bandwidth",w="bitDepth",A="bitrate",x=A+"Maximum",P=A+"Minimum",B=A+"Nominal",C="buffer",T=C+"Fullness",O="codec",$=O+"Frames",v="coupledStreamCount",S="crc",H=S+"16",E=S+"32",D="data",K="description",R="duration",j="emphasis",Q="hasOpusPadding",k="header",G="isContinuedPacket",N="isCopyrighted",V="isFirstPage",z="isHome",J="isLastPage",W="isOriginal",X="isPrivate",I="isVbr",Z="layer",F="length",Y="mode",q=Y+"Extension",_="mpeg",tt=_+"Version",st="numberAACFrames",et="outputGain",it="preSkip",rt="profile",nt=n(),ht="protection",ot="segments",at="subarray",lt="version",ct="vorbis",ut=ct+"Comments",dt=ct+"Setup",Ut="block",ft=Ut+"ingStrategy",pt=n(),Mt=Ut+"Size",yt=Ut+"size0",mt=Ut+"size1",Lt=n(),bt="channel",gt=bt+"MappingFamily",wt=bt+"MappingTable",At=bt+"Mode",xt=n(),Pt=bt+"s",Bt="copyright",Ct=Bt+"Id",Tt=Bt+"IdStart",Ot="frame",$t=Ot+"Count",vt=Ot+"Length",St="Number",Ht=Ot+St,Et=Ot+"Padding",Dt=Ot+"Size",Kt="Rate",Rt="inputSample"+Kt,jt="page",Qt=jt+"Checksum",kt=n(),Gt=jt+"SegmentTable",Nt=jt+"Sequence"+St,Vt="sample",zt=Vt+St,Jt=Vt+Kt,Wt=n(),Xt=Vt+"s",It="stream",Zt=It+"Count",Ft=It+"Info",Yt=It+"Serial"+St,qt=It+"StructureVersion",_t="total",ts=_t+"BytesOut",ss=_t+"Duration",es=_t+"Samples",is=n(),rs=n(),ns=n(),hs=n(),os=n(),as=n(),ls=n(),cs=n(),us=n(),ds=n(),Us=n(),fs=n(),ps=n(),Ms=n(),ys=n(),ms=n(),Ls=n(),bs=n(),gs=Uint8Array,ws=DataView,As="reserved",xs="bad",Ps="free",Bs="none",Cs="16bit CRC",Ts=(t,s,e)=>{for(let i=0;i<t[F];i++){let r=s(i);for(let t=8;t>0;t--)r=e(r);t[i]=r}return t},Os=Ts(new gs(256),(t=>t),(t=>128&t?7^t<<1:t<<1)),$s=[Ts(new Uint16Array(256),(t=>t<<8),(t=>t<<1^(32768&t?32773:0)))],vs=[Ts(new Uint32Array(256),(t=>t),(t=>t>>>1^3988292384*(1&t)))];for(let Mi=0;Mi<15;Mi++){$s.push(new Uint16Array(256)),vs.push(new Uint32Array(256));for(let t=0;t<=255;t++)$s[Mi+1][t]=$s[0][$s[Mi][t]>>>8]^$s[Mi][t]<<8,vs[Mi+1][t]=vs[Mi][t]>>>8^vs[0][255&vs[Mi][t]]}const Ss=t=>{const s=t[F],e=s-16;let i=0,r=0;for(;r<=e;)i=vs[15][255&(t[r++]^i)]^vs[14][255&(t[r++]^i>>>8)]^vs[13][255&(t[r++]^i>>>16)]^vs[12][t[r++]^i>>>24]^vs[11][t[r++]]^vs[10][t[r++]]^vs[9][t[r++]]^vs[8][t[r++]]^vs[7][t[r++]]^vs[6][t[r++]]^vs[5][t[r++]]^vs[4][t[r++]]^vs[3][t[r++]]^vs[2][t[r++]]^vs[1][t[r++]]^vs[0][t[r++]];for(;r!==s;)i=vs[0][255&(i^t[r++])]^i>>>8;return-1^i},Hs=(...t)=>{const s=new gs(t.reduce(((t,s)=>t+s[F]),0));return t.reduce(((t,e)=>(s.set(e,t),t+e[F])),0),s},Es=t=>String.fromCharCode(...t),Ds=[0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15],Ks=t=>Ds[15&t]<<4|Ds[t>>4];class Rs{constructor(t){this.tt=t,this.st=8*t[F]}set position(t){this.st=t}get position(){return this.st}read(t){const s=Math.floor(this.st/8),e=this.st%8;return this.st-=t,(Ks(this.tt[s-1])<<8)+Ks(this.tt[s])>>7-e&255}}class js{constructor(t,s){this.et=t,this.it=s,this[ys]()}[ms](){this.rt=!0}[ys](){this.nt=new Map,this.ht=new WeakMap,this.ot=!1,this.at=!1,this.lt=null,this.rt=!1}[Ms](t,s){if(this.it){this.lt!==t&&(this.lt=t,this.at=!0);const e=this.ht.get(this.nt.get(this.ut));this.at&&e&&this.it({dt:t,...e},s),this.at=!1}}[us](t){const s=this.nt.get(t);return s&&this.ft(t),s}[ds](t,s,e){this.rt&&(this.ot||(this.et({...s}),this.ot=!0),this.ft(t),this.nt.set(t,s),this.ht.set(s,e))}ft(t){this.it&&t!==this.ut&&(this.at=!0,this.ut=t)}}const Qs=new WeakMap,ks=new WeakMap;class Gs{constructor(t,s){this.yt=t,this.nt=s}*[ls](){let t;for(;;){if(t=yield*this.bt[Us](this.yt,this.nt,0),t)return t;this.yt[rs](1)}}*[cs](t){let s=yield*this[ls]();const e=ks.get(s)[F];if(t||this.yt.wt||(yield*this.At[us](this.yt,this.nt,e)))return this.nt[ms](),this.yt[rs](e),this.yt[hs](s),s;this.yt[os](`Missing ${Ot} at ${e} bytes from current position.`,`Dropping current ${Ot} and trying again.`),this.nt[ys](),this.yt[rs](1)}}class Ns{constructor(t,s){ks.set(this,{[k]:t}),this[D]=s}}class Vs extends Ns{static*[Us](t,s,e,i,r){const n=yield*t[us](e,i,r);if(n){const t=Qs.get(n)[vt],i=Qs.get(n)[Xt];return new s(n,(yield*e[is](t,r))[at](0,t),i)}return null}constructor(t,s,e){super(t,s),this[k]=t,this[Xt]=e,this[R]=e/t[Jt]*1e3,this[Ht]=null,this[ts]=null,this[es]=null,this[ss]=null,ks.get(this)[F]=s[F]}}const zs="unsynchronizationFlag",Js="extendedHeaderFlag",Ws="experimentalFlag",Xs="footerPresent";class Is{static*Pt(t,s,e){const i={};let r=yield*t[is](3,e);if(73!==r[0]||68!==r[1]||51!==r[2])return null;if(r=yield*t[is](10,e),i[lt]=`id3v2.${r[3]}.${r[4]}`,15&r[5])return null;if(i[zs]=!!(128&r[5]),i[Js]=!!(64&r[5]),i[Ws]=!!(32&r[5]),i[Xs]=!!(16&r[5]),128&r[6]||128&r[7]||128&r[8]||128&r[9])return null;const n=r[6]<<21|r[7]<<14|r[8]<<7|r[9];return i[F]=10+n,new Is(i)}constructor(t){this[lt]=t[lt],this[zs]=t[zs],this[Js]=t[Js],this[Ws]=t[Ws],this[Xs]=t[Xs],this[F]=t[F]}}class Zs{constructor(t){Qs.set(this,t),this[w]=t[w],this[A]=null,this[Pt]=t[Pt],this[At]=t[At],this[Jt]=t[Jt]}}const Fs={0:[Ps,Ps,Ps,Ps,Ps],16:[32,32,32,32,8],240:[xs,xs,xs,xs,xs]},Ys=(t,s,e)=>8*((t+e)%s+s)*(1<<(t+e)/s)-8*s*(s/8|0);for(let Mi=2;Mi<15;Mi++)Fs[Mi<<4]=[32*Mi,Ys(Mi,4,0),Ys(Mi,4,-1),Ys(Mi,8,4),Ys(Mi,8,0)];const qs="bands ",_s=" to 31",te={0:qs+4+_s,16:qs+8+_s,32:qs+12+_s,48:qs+16+_s},se="bitrateIndex",ee="v2",ie="v1",re="Intensity stereo ",ne=", MS stereo ",he="on",oe="off",ae={0:{[K]:As},2:{[K]:"Layer III",[Et]:1,[q]:{0:re+oe+ne+oe,16:re+he+ne+oe,32:re+oe+ne+he,48:re+he+ne+he},[ie]:{[se]:2,[Xt]:1152},[ee]:{[se]:4,[Xt]:576}},4:{[K]:"Layer II",[Et]:1,[q]:te,[Xt]:1152,[ie]:{[se]:1},[ee]:{[se]:4}},6:{[K]:"Layer I",[Et]:4,[q]:te,[Xt]:384,[ie]:{[se]:0},[ee]:{[se]:3}}},le="MPEG Version ",ce="ISO/IEC ",ue={0:{[K]:le+"2.5 (later extension of MPEG 2)",[Z]:ee,[Jt]:{0:11025,4:12e3,8:L,12:As}},8:{[K]:As},16:{[K]:`${le}2 (${ce}13818-3)`,[Z]:ee,[Jt]:{0:y,4:M,8:m,12:As}},24:{[K]:`${le}1 (${ce}11172-3)`,[Z]:ie,[Jt]:{0:f,4:U,8:p,12:As}},length:F},de={0:Cs,1:Bs},Ue={0:Bs,1:"50/15 ms",2:As,3:"CCIT J.17"},fe={0:{[Pt]:2,[K]:l},64:{[Pt]:2,[K]:"joint "+l},128:{[Pt]:2,[K]:"dual channel"},192:{[Pt]:1,[K]:a}};class pe extends Zs{static*[us](t,s,e){const i={},r=yield*Is.Pt(t,s,e);r&&(yield*t[is](r[F],e),t[rs](r[F]));const n=yield*t[is](4,e),h=Es(n[at](0,4)),o=s[us](h);if(o)return new pe(o);if(255!==n[0]||n[1]<224)return null;const a=ue[24&n[1]];if(a[K]===As)return null;const l=6&n[1];if(ae[l][K]===As)return null;const c={...ae[l],...ae[l][a[Z]]};if(i[tt]=a[K],i[Z]=c[K],i[Xt]=c[Xt],i[ht]=de[1&n[1]],i[F]=4,i[A]=Fs[240&n[2]][c[se]],i[A]===xs)return null;if(i[Jt]=a[Jt][12&n[2]],i[Jt]===As)return null;if(i[Et]=2&n[2]&&c[Et],i[X]=!!(1&n[2]),i[vt]=Math.floor(125*i[A]*i[Xt]/i[Jt]+i[Et]),!i[vt])return null;const u=192&n[3];if(i[At]=fe[u][K],i[Pt]=fe[u][Pt],i[q]=c[q][48&n[3]],i[N]=!!(8&n[3]),i[W]=!!(4&n[3]),i[j]=Ue[3&n[3]],i[j]===As)return null;i[w]=16;{const{length:t,frameLength:e,Bt:r,...n}=i;s[ds](h,i,n)}return new pe(i)}constructor(t){super(t),this[A]=t[A],this[j]=t[j],this[Et]=t[Et],this[N]=t[N],this[W]=t[W],this[X]=t[X],this[Z]=t[Z],this[q]=t[q],this[tt]=t[tt],this[ht]=t[ht]}}class Me extends Vs{static*[Us](t,s,e){return yield*super[Us](pe,Me,t,s,e)}constructor(t,s,e){super(t,s,e)}}class ye extends Gs{constructor(t,s,e){super(t,s),this.bt=Me,this.At=pe,e(this[O])}get[O](){return _}*[fs](){return yield*this[cs]()}}const me={0:"MPEG-4",8:"MPEG-2"},Le={0:"valid",2:xs,4:xs,6:xs},be={0:Cs,1:Bs},ge={0:"AAC Main",64:"AAC LC (Low Complexity)",128:"AAC SSR (Scalable Sample Rate)",192:"AAC LTP (Long Term Prediction)"},we={0:96e3,4:88200,8:64e3,12:U,16:f,20:p,24:M,28:y,32:m,36:12e3,40:11025,44:L,48:7350,52:As,56:As,60:"frequency is written explicitly"},Ae={0:{[Pt]:0,[K]:"Defined in AOT Specific Config"},64:{[Pt]:1,[K]:a},128:{[Pt]:2,[K]:u(2,h[0][0])},192:{[Pt]:3,[K]:u(3,h[1][3])},256:{[Pt]:4,[K]:u(4,h[1][3],h[3][4])},320:{[Pt]:5,[K]:u(5,h[1][3],h[3][0])},384:{[Pt]:6,[K]:u(6,h[1][3],h[3][0],o)},448:{[Pt]:8,[K]:u(8,h[1][3],h[2][0],h[3][0],o)}};class xe extends Zs{static*[us](t,s,e){const i={},r=yield*t[is](7,e),n=Es([r[0],r[1],r[2],252&r[3]|3&r[6]]),h=s[us](n);if(h)Object.assign(i,h);else{if(255!==r[0]||r[1]<240)return null;if(i[tt]=me[8&r[1]],i[Z]=Le[6&r[1]],i[Z]===xs)return null;const t=1&r[1];i[ht]=be[t],i[F]=t?7:9,i[nt]=192&r[2],i[Wt]=60&r[2];const e=2&r[2];if(i[rt]=ge[i[nt]],i[Jt]=we[i[Wt]],i[Jt]===As)return null;i[X]=!!e,i[xt]=448&(r[2]<<8|r[3]),i[At]=Ae[i[xt]][K],i[Pt]=Ae[i[xt]][Pt],i[W]=!!(32&r[3]),i[z]=!!(8&r[3]),i[Ct]=!!(8&r[3]),i[Tt]=!!(4&r[3]),i[w]=16,i[Xt]=1024,i[st]=3&r[6];{const{length:t,Ot:e,$t:r,vt:h,frameLength:o,Bt:a,St:l,...c}=i;s[ds](n,i,c)}}if(i[vt]=8191&(r[3]<<11|r[4]<<3|r[5]>>5),!i[vt])return null;const o=2047&(r[5]<<6|r[6]>>2);return i[T]=2047===o?"VBR":o,new xe(i)}constructor(t){super(t),this[Ct]=t[Ct],this[Tt]=t[Tt],this[T]=t[T],this[z]=t[z],this[W]=t[W],this[X]=t[X],this[Z]=t[Z],this[F]=t[F],this[tt]=t[tt],this[st]=t[st],this[rt]=t[rt],this[ht]=t[ht]}get Ht(){const t=Qs.get(this),s=t[nt]+64<<5|t[Wt]<<5|t[xt]>>3,e=new gs(2);return new ws(e[C]).setUint16(0,s,!1),e}}class Pe extends Vs{static*[Us](t,s,e){return yield*super[Us](xe,Pe,t,s,e)}constructor(t,s,e){super(t,s,e)}}class Be extends Gs{constructor(t,s,e){super(t,s),this.bt=Pe,this.At=xe,e(this[O])}get[O](){return"aac"}*[fs](){return yield*this[cs]()}}class Ce extends Vs{static Et(t){return(t[t[F]-2]<<8)+t[t[F]-1]}static[bs](t){const s=Ce.Et(t),e=(t=>{const s=t[F],e=s-16;let i=0,r=0;for(;r<=e;)i^=t[r++]<<8|t[r++],i=$s[15][i>>8]^$s[14][255&i]^$s[13][t[r++]]^$s[12][t[r++]]^$s[11][t[r++]]^$s[10][t[r++]]^$s[9][t[r++]]^$s[8][t[r++]]^$s[7][t[r++]]^$s[6][t[r++]]^$s[5][t[r++]]^$s[4][t[r++]]^$s[3][t[r++]]^$s[2][t[r++]]^$s[1][t[r++]]^$s[0][t[r++]];for(;r!==s;)i=(255&i)<<8^$s[0][i>>8^t[r++]];return i})(t[at](0,-2));return s===e}constructor(t,s,e){s[Ft]=e,s[H]=Ce.Et(t),super(s,t,Qs.get(s)[Xt])}}const Te="get from STREAMINFO metadata block",Oe={0:"Fixed",1:"Variable"},$e={0:As,16:192};for(let Mi=2;Mi<16;Mi++)$e[Mi<<4]=Mi<6?576*2**(Mi-2):2**Mi;const ve={0:Te,1:88200,2:176400,3:192e3,4:L,5:m,6:y,7:M,8:p,9:f,10:U,11:96e3,15:xs},Se={0:{[Pt]:1,[K]:a},16:{[Pt]:2,[K]:u(2,h[0][0])},32:{[Pt]:3,[K]:u(3,h[0][1])},48:{[Pt]:4,[K]:u(4,h[1][0],h[3][0])},64:{[Pt]:5,[K]:u(5,h[1][1],h[3][0])},80:{[Pt]:6,[K]:u(6,h[1][1],o,h[3][0])},96:{[Pt]:7,[K]:u(7,h[1][1],o,h[3][4],h[2][0])},112:{[Pt]:8,[K]:u(8,h[1][1],o,h[3][0],h[2][0])},128:{[Pt]:2,[K]:l+" (left, diff)"},144:{[Pt]:2,[K]:l+" (diff, right)"},160:{[Pt]:2,[K]:l+" (avg, diff)"},176:As,192:As,208:As,224:As,240:As},He={0:Te,2:8,4:12,6:As,8:16,10:20,12:24,14:As};class Ee extends Zs{static Kt(t){if(t[0]>254)return null;if(t[0]<128)return{value:t[0],length:1};let s=1;for(let n=64;n&t[0];n>>=1)s++;let e=s-1,i=0,r=0;for(;e>0;r+=6,e--){if(128!=(192&t[e]))return null;i|=(63&t[e])<<r}return i|=(t[e]&127>>s)<<r,{value:i,length:s}}static[Ls](t,s){const e={*[is](){return t}};return Ee[us](e,s,0).next().value}static*[us](t,s,e){let i=yield*t[is](6,e);if(255!==i[0]||248!==i[1]&&249!==i[1])return null;const r={},n=Es(i[at](0,4)),h=s[us](n);if(h)Object.assign(r,h);else{if(r[pt]=1&i[1],r[ft]=Oe[r[pt]],r[Lt]=240&i[2],r[Wt]=15&i[2],r[Mt]=$e[r[Lt]],r[Mt]===As)return null;if(r[Jt]=ve[r[Wt]],r[Jt]===xs)return null;if(1&i[3])return null;const t=Se[240&i[3]];if(t===As)return null;if(r[Pt]=t[Pt],r[At]=t[K],r[w]=He[14&i[3]],r[w]===As)return null}r[F]=5,i=yield*t[is](r[F]+8,e);const o=Ee.Kt(i[at](4));if(!o)return null;if(r[pt]?r[zt]=o.value:r[Ht]=o.value,r[F]+=o[F],96===r[Lt]?(i[F]<r[F]&&(i=yield*t[is](r[F],e)),r[Mt]=i[r[F]-1]+1,r[F]+=1):112===r[Lt]&&(i[F]<r[F]&&(i=yield*t[is](r[F],e)),r[Mt]=(i[r[F]-1]<<8)+i[r[F]]+1,r[F]+=2),r[Xt]=r[Mt],12===r[Wt]?(i[F]<r[F]&&(i=yield*t[is](r[F],e)),r[Jt]=1e3*i[r[F]-1],r[F]+=1):13===r[Wt]?(i[F]<r[F]&&(i=yield*t[is](r[F],e)),r[Jt]=(i[r[F]-1]<<8)+i[r[F]],r[F]+=2):14===r[Wt]&&(i[F]<r[F]&&(i=yield*t[is](r[F],e)),r[Jt]=10*((i[r[F]-1]<<8)+i[r[F]]),r[F]+=2),i[F]<r[F]&&(i=yield*t[is](r[F],e)),r[S]=i[r[F]-1],r[S]!==(t=>{let s=0;const e=t[F];for(let i=0;i!==e;i++)s=Os[s^t[i]];return s})(i[at](0,r[F]-1)))return null;if(!h){const{Qt:t,frameNumber:e,kt:i,Bt:h,vt:o,Gt:a,Nt:l,length:c,...u}=r;s[ds](n,r,u)}return new Ee(r)}constructor(t){super(t),this[H]=null,this[ft]=t[ft],this[Mt]=t[Mt],this[Ht]=t[Ht],this[zt]=t[zt],this[Ft]=null}}class De extends Gs{constructor(t,s,e){super(t,s),this.bt=Ce,this.At=Ee,e(this[O])}get[O](){return"flac"}*Vt(t){const s=yield*this.yt[is](2,0),e=s[F]-2;for(;t<e;){if(255===s[t]){const e=s[t+1];if(248===e||249===e)break;255!==e&&t++}t++}return t}*[fs](){for(;;){const t=yield*Ee[us](this.yt,this.nt,0);if(t){let s=Qs.get(t)[F]+2;for(;s<=524288;){if(this.yt.wt||(yield*Ee[us](this.yt,this.nt,s))){let e=yield*this.yt[is](s);if(this.yt.wt||(e=e[at](0,s)),Ce[bs](e)){const i=new Ce(e,t);return this.nt[ms](),this.yt[rs](s),this.yt[hs](i),i}}s=yield*this.Vt(s+1)}this.yt[os](`Unable to sync FLAC frame after searching ${s} bytes.`),this.yt[rs](s)}else this.yt[rs](yield*this.Vt(1))}}[ps](t){return 0===t[Nt]?(this.nt[ms](),this.Jt=t[D][at](13)):1===t[Nt]||(t[$]=ks.get(t)[ot].map((t=>{const s=Ee[Ls](t,this.nt);if(s)return new Ce(t,s,this.Jt);this.yt[os]("Failed to parse Ogg FLAC frame","Skipping invalid FLAC frame")})).filter((t=>!!t))),t}}class Ke{static*[us](t,s,e){const i={};let r=yield*t[is](28,e);if(79!==r[0]||103!==r[1]||103!==r[2]||83!==r[3])return null;if(i[qt]=r[4],248&r[5])return null;i[J]=!!(4&r[5]),i[V]=!!(2&r[5]),i[G]=!!(1&r[5]);const n=new ws(gs.from(r[at](0,28))[C]);try{i[b]=n.getBigInt64(6,!0)}catch{}i[Yt]=n.getInt32(14,!0),i[Nt]=n.getInt32(18,!0),i[Qt]=n.getInt32(22,!0);const h=r[26];i[F]=h+27,r=yield*t[is](i[F],e),i[vt]=0,i[Gt]=[],i[kt]=gs.from(r[at](27,i[F]));for(let o=0,a=0;o<h;o++){const t=i[kt][o];i[vt]+=t,a+=t,255===t&&o!==h-1||(i[Gt].push(a),a=0)}return new Ke(i)}constructor(t){Qs.set(this,t),this[b]=t[b],this[G]=t[G],this[V]=t[V],this[J]=t[J],this[Gt]=t[Gt],this[Nt]=t[Nt],this[Qt]=t[Qt],this[Yt]=t[Yt]}}class Re extends Ns{static*[Us](t,s,e){const i=yield*Ke[us](t,s,e);if(i){const s=Qs.get(i)[vt],e=Qs.get(i)[F],r=e+s,n=(yield*t[is](r,0))[at](0,r),h=n[at](e,r);return new Re(i,h,n)}return null}constructor(t,s,e){super(t,s),ks.get(this)[F]=e[F],this[$]=[],this.Wt=e,this[b]=t[b],this[E]=t[Qt],this[R]=0,this[G]=t[G],this[V]=t[V],this[J]=t[J],this[Nt]=t[Nt],this[Xt]=0,this[Yt]=t[Yt]}}class je extends Vs{constructor(t,s){super(s,t,s[Dt]*s[$t]/1e3*s[Jt])}}const Qe={0:d.slice(0,2),1:d},ke="SILK-only",Ge="CELT-only",Ne="Hybrid",Ve="narrowband",ze="medium-band",Je="wideband",We="super-wideband",Xe="fullband",Ie={0:{[Y]:ke,[g]:Ve,[Dt]:10},8:{[Y]:ke,[g]:Ve,[Dt]:20},16:{[Y]:ke,[g]:Ve,[Dt]:40},24:{[Y]:ke,[g]:Ve,[Dt]:60},32:{[Y]:ke,[g]:ze,[Dt]:10},40:{[Y]:ke,[g]:ze,[Dt]:20},48:{[Y]:ke,[g]:ze,[Dt]:40},56:{[Y]:ke,[g]:ze,[Dt]:60},64:{[Y]:ke,[g]:Je,[Dt]:10},72:{[Y]:ke,[g]:Je,[Dt]:20},80:{[Y]:ke,[g]:Je,[Dt]:40},88:{[Y]:ke,[g]:Je,[Dt]:60},96:{[Y]:Ne,[g]:We,[Dt]:10},104:{[Y]:Ne,[g]:We,[Dt]:20},112:{[Y]:Ne,[g]:Xe,[Dt]:10},120:{[Y]:Ne,[g]:Xe,[Dt]:20},128:{[Y]:Ge,[g]:Ve,[Dt]:2.5},136:{[Y]:Ge,[g]:Ve,[Dt]:5},144:{[Y]:Ge,[g]:Ve,[Dt]:10},152:{[Y]:Ge,[g]:Ve,[Dt]:20},160:{[Y]:Ge,[g]:Je,[Dt]:2.5},168:{[Y]:Ge,[g]:Je,[Dt]:5},176:{[Y]:Ge,[g]:Je,[Dt]:10},184:{[Y]:Ge,[g]:Je,[Dt]:20},192:{[Y]:Ge,[g]:We,[Dt]:2.5},200:{[Y]:Ge,[g]:We,[Dt]:5},208:{[Y]:Ge,[g]:We,[Dt]:10},216:{[Y]:Ge,[g]:We,[Dt]:20},224:{[Y]:Ge,[g]:Xe,[Dt]:2.5},232:{[Y]:Ge,[g]:Xe,[Dt]:5},240:{[Y]:Ge,[g]:Xe,[Dt]:10},248:{[Y]:Ge,[g]:Xe,[Dt]:20}};class Ze extends Zs{static[Ls](t,s,e){const i={};if(i[Pt]=t[9],i[gt]=t[18],i[F]=0!==i[gt]?21+i[Pt]:19,t[F]<i[F])throw Error("Out of data while inside an Ogg Page");const r=3&s[0],n=3===r?2:1,h=Es(t[at](0,i[F]))+Es(s[at](0,n)),o=e[us](h);if(o)return new Ze(o);if("OpusHead"!==h.substr(0,8))return null;if(1!==t[8])return null;i[D]=gs.from(t[at](0,i[F]));const a=new ws(i[D][C]);if(i[w]=16,i[it]=a.getUint16(10,!0),i[Rt]=a.getUint32(12,!0),i[Jt]=U,i[et]=a.getInt16(16,!0),i[gt]in Qe&&(i[At]=Qe[i[gt]][i[Pt]-1],!i[At]))return null;0!==i[gt]&&(i[Zt]=t[19],i[v]=t[20],i[wt]=[...t[at](21,i[Pt]+21)]);const l=Ie[248&s[0]];switch(i[Y]=l[Y],i[g]=l[g],i[Dt]=l[Dt],r){case 0:i[$t]=1;break;case 1:case 2:i[$t]=2;break;case 3:i[I]=!!(128&s[1]),i[Q]=!!(64&s[1]),i[$t]=63&s[1];break;default:return null}{const{length:t,data:s,Xt:r,...n}=i;e[ds](h,i,n)}return new Ze(i)}constructor(t){super(t),this[D]=t[D],this[g]=t[g],this[gt]=t[gt],this[wt]=t[wt],this[v]=t[v],this[$t]=t[$t],this[Dt]=t[Dt],this[Q]=t[Q],this[Rt]=t[Rt],this[I]=t[I],this[Y]=t[Y],this[et]=t[et],this[it]=t[it],this[Zt]=t[Zt]}}class Fe extends Gs{constructor(t,s,e){super(t,s),this.bt=je,this.At=Ze,e(this[O]),this.It=null}get[O](){return"opus"}[ps](t){return 0===t[Nt]?(this.nt[ms](),this.It=t[D]):1===t[Nt]||(t[$]=ks.get(t)[ot].map((t=>{const s=Ze[Ls](this.It,t,this.nt);if(s)return new je(t,s);this.yt[as]("Failed to parse Ogg Opus Header","Not a valid Ogg Opus file")}))),t}}class Ye extends Vs{constructor(t,s,e){super(s,t,e)}}const qe={};for(let Mi=0;Mi<8;Mi++)qe[Mi+6]=2**(6+Mi);class _e extends Zs{static[Ls](t,s,e,i){if(t[F]<30)throw Error("Out of data while inside an Ogg Page");const r=Es(t[at](0,30)),n=s[us](r);if(n)return new _e(n);const h={[F]:30};if("vorbis"!==r.substr(0,7))return null;h[D]=gs.from(t[at](0,30));const o=new ws(h[D][C]);if(h[lt]=o.getUint32(7,!0),0!==h[lt])return null;if(h[Pt]=t[11],h[At]=d[h[Pt]-1]||"application defined",h[Jt]=o.getUint32(12,!0),h[x]=o.getInt32(16,!0),h[B]=o.getInt32(20,!0),h[P]=o.getInt32(24,!0),h[mt]=qe[(240&t[28])>>4],h[yt]=qe[15&t[28]],h[yt]>h[mt])return null;if(1!==t[29])return null;h[w]=32,h[dt]=i,h[ut]=e;{const{length:t,data:e,version:i,Zt:n,Ft:o,...a}=h;s[ds](r,h,a)}return new _e(h)}constructor(t){super(t),this[x]=t[x],this[P]=t[P],this[B]=t[B],this[yt]=t[yt],this[mt]=t[mt],this[D]=t[D],this[ut]=t[ut],this[dt]=t[dt]}}class ti extends Gs{constructor(t,s,e){super(t,s),this.bt=Ye,e(this[O]),this.It=null,this.Yt=!1,this.qt={count:0},this._t=0,this.ts=0}get[O](){return ct}[ps](t){t[$]=[];for(const s of ks.get(t)[ot])if(1===s[0])this.nt[ms](),this.It=t[D],this.Yt=!1;else if(3===s[0])this.ss=s;else if(5===s[0])this.es=s,this.qt=this.rs(s),this.Yt=!0;else if(this.Yt){const e=_e[Ls](this.It,this.nt,this.ss,this.es);e?t[$].push(new Ye(s,e,this.ns(s,e))):this.yt[as]("Failed to parse Ogg Vorbis Header","Not a valid Ogg Vorbis file")}return t}ns(t,s){const e=t[0]>>1,i=this.qt[e&this.qt.mask];i&&(this._t=e&this.qt.hs?s[mt]:s[yt]),this.ts=i?s[mt]:s[yt];const r=this._t+this.ts>>2;return this._t=this.ts,r}rs(t){const s=new Rs(t),e="Failed to read "+ct+" stream",i=", failed to parse "+ct+" modes";let r,n={count:0};for(;1!=(1&s.read(1)););for(;n.count<64&&s.position>0;){const t=Ks(s.read(8));if(t in n&&(1!==n.count||0!==t))throw this.yt[as]("received duplicate mode mapping"+i),Error(e);let h=0;for(;0===s.read(8)&&h++<3;);if(4!==h){if(1+((126&Ks(r))>>1)!==n.count)throw this.yt[as]("mode count did not match actual modes"+i),Error(e);break}r=s.read(7),n[t]=1&r,s.position+=6,n.count++}return n.mask=(1<<Math.log2(n.count))-1,n.hs=1+(1|n.mask),n}}class si{constructor(t,s,e){this.yt=t,this.nt=s,this.os=e,this.ls=new gs,this.cs=null,this.us=null}get[O](){return this.cs||""}ds(t,s){this.cs!==t&&(this.nt[ys](),this.Us=new s(this.yt,this.nt,this.os),this.cs=t)}fs({data:t}){const s=Es(t[at](0,8));switch(s){case"fishead\0":return!1;case"OpusHead":return this.ds("opus",Fe),!0;case/^\x7fFLAC/.test(s)&&s:return this.ds("flac",De),!0;case/^\x01vorbis/.test(s)&&s:return this.ds(ct,ti),!0;default:return!1}}ps(t){t[Nt]!==this.Ms+1&&this.Ms>1&&t[Nt]>1&&this.yt[os]("Unexpected gap in Ogg Page Sequence Number.",`Expected: ${this.Ms+1}, Got: ${t[Nt]}`),this.Ms=t[Nt]}ys(t){null===this.us&&(this.Ms=t[Nt],this.us=this.fs(t)),this.ps(t);const s=ks.get(t),e=Qs.get(s[k]);let i=0;if(s[ot]=e[Gt].map((s=>t[D][at](i,i+=s))),this.ls[F]&&(s[ot][0]=Hs(this.ls,s[ot][0]),this.ls=new gs),255===e[kt][e[kt][F]-1]&&(this.ls=Hs(this.ls,s[ot].pop())),this.us){const s=this.Us[ps](t);return this.yt[hs](s),s}return t}}class ei extends Gs{constructor(t,s,e){super(t,s),this.os=e,this.bt=Re,this.At=Ke,this.Ls=new Map,this.bs=null}get[O](){const t=this.Ls.get(this.bs);return t?t.Ct:""}*[fs](){const t=yield*this[cs](!0);this.bs=t[Yt];let s=this.Ls.get(this.bs);return s||(s=new si(this.yt,this.nt,this.os),this.Ls.set(this.bs,s)),t[J]&&this.Ls.delete(this.bs),s.ys(t)}}const ii=()=>{};class ri{constructor(t,{gs:s,ws:e,As:i,xs:r=!1,Ps:n=!0}={}){this.Bs=t,this.os=s||ii,this.et=e||ii,this.it=i,this.Cs=r,this.Ts=n?Ss:ii,this.Os=this.$s(),this.Os.next()}get[O](){return this.Us[O]}*flush(){this.wt=!0;for(let t=this.Os.next();t.value;t=this.Os.next())yield t.value;this.wt=!1,this.Os=this.$s(),this.Os.next()}*vs(t){for(let s=this.Os.next(t);s.value;s=this.Os.next())yield s.value}parseAll(t){return[...this.vs(t),...this.flush()]}*$s(){if(this.nt=new js(this.et,this.it),this.Bs.match(/aac/))this.Us=new Be(this,this.nt,this.os);else if(this.Bs.match(/mpeg/))this.Us=new ye(this,this.nt,this.os);else if(this.Bs.match(/flac/))this.Us=new De(this,this.nt,this.os);else{if(!this.Bs.match(/ogg/))throw Error("Unsupported Codec "+mimeType);this.Us=new ei(this,this.nt,this.os)}for(this.Ss=0,this.Hs=0,this.Es=0,this.Ds=0,this.Ks=0,this.Rs=void 0,this.js=new Uint8Array(0);;){const t=yield*this.Us[fs]();t&&(yield t)}}*[is](t=0,s=0){let e;for(;this.js[F]<=t+s;){if(e=yield,this.wt)return this.js[at](s);e&&(this.Es+=e[F],this.js=Hs(this.js,e))}return this.js[at](s)}[rs](t){this.Hs+=t,this.js=this.js[at](t)}[ns](t){this.Rs=t[k][Jt],t[k][A]=8*Math.round(t[D][F]/t[R]),t[Ht]=this.Ss++,t[ts]=this.Ds,t[es]=this.Ks,t[ss]=this.Ks/this.Rs*1e3,t[E]=this.Ts(t[D]),this.nt[Ms](t[k][A],t[ss]),this.Ds+=t[D][F],this.Ks+=t[Xt]}[hs](t){t[$]?(t[$].forEach((s=>{t[R]+=s[R],t[Xt]+=s[Xt],this[ns](s)})),t[es]=this.Ks,t[ss]=this.Ks/this.Rs*1e3||0,t[ts]=this.Ds):this[ns](t)}Ns(t,s){if(this.Cs){const e=[`${O}:         ${this[O]}`,"inputMimeType: "+this.Bs,"readPosition:  "+this.Hs,"totalBytesIn:  "+this.Es,`${ts}: ${this.Ds}`],i=Math.max(...e.map((t=>t[F])));s.push("--stats--"+"-".repeat(i-9),...e,"-".repeat(i)),t("codec-parser",s.reduce(((t,s)=>t+"\n  "+s),""))}}[os](...t){this.Ns(console.warn,t)}[as](...t){this.Ns(console.error,t)}}const ni=$,hi=D,oi=k,ai=ut,li=dt;function ci(t){function s(){}for(var e=new Uint8Array(123),i=25;i>=0;--i)e[48+i]=52+i,e[65+i]=i,e[97+i]=26+i;var r,n;e[43]=62,e[47]=63,ci.L||Object.defineProperty(ci,"L",{get:()=>String.raw`dynEncode01df9b7dd5a5+nd ã ë$Þ.¥ÐåæÙ_ýÅOV;ÈCæ<XP¢ÛÕ{ß×°¤kµHÏ¾ô¶a¸Ï%Ú5×¥BÏc=}{8ÑÄ@Ýø\¾Z^h_Kõ­&QÍëÍíÍìÍîý?¨XçPýÇÕõç¨ïg=M
ä
M,=}§EÙâÞï"j£õ~l<îp6{¬Aöo38i(Qosx´z<NRX¯³RÎePØ]34N«²LEEEerxxØIEEùÞþ©­»ÜQóigþþ©axHÌLþTTÍPÑïKV§£¨<¨¼E»BU§E»FU¨³§wd²äbÔµzí<T¼Í¬½\ÚîûHMÔi
zº%>RÔ¶¾OÂPÎ\y×[
¤<éq¹:Û1Æ·Tj1æËþµIhdí&vÛCÎ¯ãöK¥¨Sñi"èUGqý
r<(Jbuv%V ®9 5OãS)ùã88Mä¼Ë:Î¹ÎUH¢Y¾d-z¹]«¯l´= ´SCáÑ¿ÍG¦Jïû$ôÿÄH-fr 79-/a ýÏÎ´õbhapí.:"ìZ®ähu_(÷¸= º¾nHw"úìPP³-ý: ¿íøL;LÏ;ë·Q¢Y©ïC8Ë	t°G±ðR'ìVò#ñÁµ?ýóD*Ý]l­Ü±kâMzÿÿO³Q3Ùâ²,à®¬âaÖ>uÙëÝë80:bøÓvq.^]ÄR"UåÖ­À	FÉY°qT3Kb¢,]'¡¢uEÎU¨¸Mj7¹4eºHÛîKÝÞO2zÕ|.h´sf	3nkÄ2¹©ýíÄzâ{ã ÂëÛ1e>aH%aÃ)ö%xêB íÚ¶·Îmñï+aöÌÑónÄÀ?¾Ø³¦â*ím´URÚ¯³¼O:µØÏ[£z¥AZÄÕÛÒVÁ]®(ÎdºOºÍù)Î+(24ÇÏýê4ø:øàj-Ô\ªÜaÝç®ãyrt84µÊÈô7	¯lÉ¿ÊÎ7?Dk_/HüútzÇPçMÅÀºd[Ñn&Ü( .JU»;ùY°v¶P?CzÛeðWnB®²$­ÈèKù<x[ AQw8·º8ããæDµ'o³Ë±ÓõúÅ%Óí@MCdõxIa¼[ÐCÈø,§FVs%)2xr¬á½zµx¨NbÝUe5¢Ô«Mxâîb¨l&zß¤[PÒüueÄh]~-2è®ß(_<ý\¡d¹ÌÑé|§lX÷±APBP"M-­,rz$e>UQLÇ|ÃG×L7mMñ7ñÄHß;M"My»ëQ"Äàr÷ºeÛ¨CFê¨)#WmXÃJ¸«9²X1i:DUÅc§ÞÕ%$R{ýl½ª£¥@ýî5{Q
a[
d¶d¥UECÎ³3øPy¤c|¨5â²]6¶vÃ'ÜünIV(>õs_¨U= U(5§ðSàÐ@Áo[
W[LàpÂÂ/?Á'0¾ñ){9 Þj/ÃÅ',GÏ6W$nÊånYq:tC§WÇ¿j:¡Ûáxr»My©0T¬EbP¬Pk#ñ[H¬ikx»±aÂÐai¦7T«}ö2pÍ¬HIkdñN1w©<å¯ÿª0È»¯<GZàCÕ4sâT:UÜ{Aä5T£âWe¹X2þªÅ;åÈ=}ýSRÓ0^::õ= [R9F5Íf(£ükA	B$wmÁè5ÆVgÏÃ¬;¸NµZÇZÏÉEuá3°yTFi»W,OfCù~@ÉøG}~²9jWqøÔk#?áÙÅ:ç±ø¶TUpÃ·uÐä¥oÊ×8Q#Lp=}Ól¤>¾Êõ=Mäjl\¹"%µînvÌDÀÀÍ=MÜ«¢Q¥= U 'J¢áÛ¿¥u}5" -%àÎA9FÖ¨LdÜ)D©¹çôÜ·f7häXñëqdm= Ë¶1fãFDË¼kåøYoÚJÊçiD²oÔÄzEë jaµâ¦sÍÉà=}+=MûÏd ñlíDÜ7.HlF$2À£Iá±G|´½ÚPõP¿j)G:÷¬¨Fïs15bmäyGë/¡ú}öá\·CÁÔHèß= +ÒýY$8±*sÌ5	±îtùÄ])÷= ´ *@C"u­÷¸S­§}rê%Õa<vCÈip*6nË´8]CfF*òYeåÐí°Oª/m=}q6ã¯#zxþ>Ní¿Óý×¾' 	8õ>t{uºB:ÂÂ^¦"S9Í+ »YµÝ=}, M78E¦Ü²ÈÚKXyÃFÈ¸YÞ~ì_*üæËÚf~^ÆU!ÿÓl\ÂLäæoOtÖ)bÌ/(}qM£9V>)^¥ÏJ¸ì8èíÛÕ¾@¤WÜùæ!Ð7ó^=MGôÛi¤Ð¦AvÑþÜ½ïb¿¹äÉÊ£¿e"ýW= ÕWq*ªGxÜ÷rënºßrKôDt/ÉiPù+°âeç5öq<cxÎ¢!j?´³ÓB ÑbØüa¢öï9¥á¿rHüæípKä;ÌM¸âüp¡!R}µ/*:ä[¦Þè5Æp~f\¾üíZ¡ÍÊê#5t¥Ý}PýZÞÃäÂ²>¹Wê3åHt4 6ß9Án$áSvÊì\8¿ô¥µNóµb<ÿ·dåèX=}È<BÇüÈ©ÊXAÇvû«Iß=}FÔÀ_aq²i¿ÒWÙ7Lm}sk&Ý	!eV|¦@'èjíÄÎwxÞ!ÔKÜºU+IVÌ"¾ÄÉryôýY¶sèO4Ox5Vþ|rÇ1¬¥w>4÷÷õ¨³ !?¢2_oD5,E¹ÿ¼æ¾éü©@À\ëÓocËÃÎ|B^h§BÃ~7#õ3Db°pNXLH;âÎÉõíÄÈÜº^Þü¢7q^¦oÛ= þÃ>\æoü&QD6TTÞÝÚÞÈxØßåw x<£ÍáëTaÐ(IäùXÎ£×â£­pûMg¹oöb%§êÁÉF»Pô (Z½ZÎÖ½Æªö4°^EÐûï<IÑà>bÖgÚÕÇXÖØ_Î±à¾Èàþýî×³B¦ßå³B1F»êUzýBÄWÜ¨±¼Ì·tN§Å2~ª è»Cè§ôÖl¯Úw3 Ä ¢¾Ï(!ûâ@-3ìLþÖµñëÕe7×ï£ÓÈ¢%av)Ïqãn= ãvoè=M èý- W'ãîð»
 èMùç~çíë'O.aê8<ø ÏiãÆpvfi¶ÿ­7»ç@c¤#GÞ££}(è&ïvæ§ú±}mE1f]BR]þ­LiZ_]éµãê,+ÔðL|ÁÒ¢m¾Õ<Ü-]©BßÿñÍD8g[^#~*Ó5! c|k|W¬{##ÎAÝ±L2ÏGÍ
7éÚ²ñ\Ñ©Ïµ÷)·5è!dG*ãå+AÂþäzÄKEGÖÆYëzÄ(Ký©·Í«ïE¤²ð9EcýùSDcïiü÷
òÞÙúÊÐ"¶¤ò|Ú7@Uhúl7âK»AJî{ú*äQÈQ	?7ùBl;ãQÉ´Äÿ¼ùå6³ ke½KéÑ©ì7´´"/smGQßÌßgsCO#{®g=}ê
¸0+äÛb¥Ä^~]#Æ©ú)¶|ÒÙòLÞè¢®q]IdßÌ~çKHçeêbi1Ø®ð«gÔ4A&;ÜBúJ÷]ÈA>ÒÌ¦È ßc>+¼Ôö{¸çïr³± X²0² súµlÑóÊ%ÿWË¤Yææù9óáúýh!)Mÿxµl{["§CÏÑe{æÊåÒ+½¼Ãñ¯;?Ò?²"
1ÒcZ¾KMÖîÈ}¹æe)Áª:Íãº7îi/¬TPÄ}¢5yJÚ4tÄ n3§GÁÁ%c)Ä/¹ú¢óÛîÁáÐÔÉb¹TöÌ/é¡mW²ÛÇµÜõv­qLEwïÚ¢õUÍµ­©(ÜË¤ÄÁm³vXE·´FË1´îSDï·Pø©+}±ïPßLìüDqôò²¹£,(´ø0Ûz®ÂËmüqDP\71ãGLx(F?Áxëå= ëã8RìË¼ã*«,S8= @Feö7ú:oüéÓHsá{_opõæó¤tuænó!îôerqlZ½=}VþM¼s"SÅAýÙ@~»QõËjÙæ×ÐÐèâyYÔæaÎOn!wý© lÀûæVe £÷|*ÖËÿ)&Toú´Gs§ð<ExôJxò£KÄedË´GÖ<þEQ-H7¦(²t¶¢täT'øvp9Ðf×T1J1°²èJ4_£*38%·.k3Æ§çbH¯bÊÊÀ]¬}Hïlö§ë= ÈâG¯gfU&æ/í!ýV]QµÑA|øu«Zh0YCWx9ÉÜ'ü½Î´õí£ËM£*U¥´Ãd©Q[óZÄ<¶àÙ|J+þz4:w%±Bn¯ÁâûZ¯FÏXÖ¯.râ<Øô®bÛ;Á&0ØSUk¢"Xbf8û£ffb­»@ªS |Ë©õã¸õZ½T 9±@ÏxûÉýs:6x'f7+Ã¶Qà²pÌÊ
äUCAqJf¬ÜÔLþ1BÇ¯aàî»}2÷bÈ¬G+= ¥óG;Q=}7ªxúPfWËkÏ·pk¦D ý'R\= ¬ØÂ·KàzA²a¿Yº(ÐSd5 IÍÐ²Ò²Ï2Wgö§a&¢3 ~M²ÌGz|¨-·9q7Ù²'|=}ìY¸9:¸ÄøtÕ+µbìú¿(PÓ/[½,?´ÄQ®¥þý?å;? Bc-ø_*
=Mý{ììs2¦tß3s7ô¹õ£rU\gÑü©VQ ¬£L2	oêVDvÚ0xóÂjtCVRßvLzÈjÔoZpT;AuÅWîcy;sT°Oµt_pEBÌÌ;Cþ17ääá8Û­ÿ^Õ/K®£/$2}BÞûV/ñz©ú°Dµ/»?Ú-7uP¹;TÃ&ÍXMh±-ïé¶¾[=}Y72YÜNÕ´n¦Å&ý
Ë¾¾9\óBðâåÅ>°!ÒÙÒ£Vpi?VEåkM÷²´0Ú6ùQ)=M $MG*= óX )ï@zÓ³¬3?xä¨º^¿{Z=}é5»ÛWSÁ]3¹¸f4;"F³'Þ¸9ÏÊÐÜÉ©)ÏÊ¨Ü´ÌÙAp¢#ÉÒ°Jb"r:¥´Ùfâ´¦éÛÖRÕÊÐÜ´Þ·!ð{[×6?Ñ\ ¾Ø Þ8¿ÐáþX¹])ÞL*jGàbÝnÓp¾Ú¹úI]S3GÎ~míååÑH¤=}µ£Íº¥ÜÿtX¼ôA¸ âKä´pÁ¸-ÇVC¡÷«AíÁv+(D'èvª=}@_*Þ"8&ÄÒÍäûN#ûäÚUwyPj@¯D:"*Ã^înÜª.ÜÞÂpÖÝbfÕrP¨YÊ´(ø0¹MóÊ«ÃÖÕÞTwIÑ¦)F,ÈË2!*üYÝ9{Ô¤ú6éò
´x$«YÞ¥Ö1§7(l´Ñ9
GµÄXý;,g5"¦ÓOå£?Ä~@R¡ÀsÕ±ç²2mí~üyt{eÔÃïÊNJH:îêý®©4iá Þk¸ü¸»R'$îïFé<§jñX¥CJêØ= :ÿSÒ°
NÎo<y= YÌÎÏX Ôàû¥Ï÷ª6×j+
A&AHa?E<i,{»A+Âï\VKÃähe=M8%$ù^¼ií©®:°¾YÓ¾e.]×çiÝ´óëß³×Ó°JîÌ7Ák ²ýA7)¯õRê*ÅCç	Ììµ½t ®?:æµµF/º
1¤×_Hù¹r^?éÖÎL^¥ø'e(%(uoì:ÜpKîgGNìä!Q|Å¥è±o×²6ÂË5!xÉ:ðg_o²/éeEv§ÈpÈ7EñB×iÕÜ²Y'ÆÒQ-H9ô)³Þ](Ãµz}àþÇ'P¢yc2wîä6³º&¼ü²cD@ñul´Ð*×µÝ°©3c~L×ºO¯fãFP¸Ö«xÎ¸#p"oËù·àOü©Bæýùteé<æå+|]ìSÈýÏ= A·ÁÈôV1>êáÉJ5[µ¶IÏýÐ¾ý
ÉJÔ(>Ê4>j;n»2ÓÔµ|³¶>$Òcõ|1(ê"YÕÃ»ÆM»RãéyWÀ0^ÃDÜè³ºtU.qIYWÞs
(ÑS©t;XùÄ¡ÞôÄa0müìáÚÚ»p­RAe¬cWxn$öò¢°Õb ,KÙû/bex%é\tÿÉ<÷dtú©5ÇuÑùîû{V<«»èVHaVLþ0Jò×J72x$?R·e]*9Ì¡7m?«µc°ü÷(Ä{@ÎéB"¯xç0móZ ®Ió6
xÙÖÆÅ¯å9+óÍylÞ«8LûÿßÓÜpâÁ¦áó~]µÒêôÓÜeÓ<M£ÕAæúø¤56aÜ8Ò»Éf®Õ :lóRKËúOVíeó3 Üg´\òðn·Ã8)>vÓ¯°Mx²ÔËúÙöH è)ãx÷Ls/è-eôÒJwÍA½î(;ÂãÚ=  Zô|èyåð·] ?EÚ@ÌÏ´Ý'èilïOÁvO}±Ùôæì;!¥ÙK,Ã¿ø{ï¯mcÅ·ÆgôñùÊn@øe±¿-&lã÷;úë£¤â2Sd»ázÓÜR:û°MÔÍWàÂvòE¿¿¥$U8a|4Á<ì¿[ª$j»³Ã?Díý9%íüÇ+übw#æA(bU#
sÇàU¯
¸DóþÅ~	N	wdÒ/*+K,Ê
3/xE>m³!.{©
3ðýÝ0gõ·[âÂ)K¿1£J,ü¯µ2¯ÅPûz+Kçxû"ÉüuñÚ´úðmGVÜOòÑ»7Ò.¤wN)îP{3Hs³áyÚxAtbö*¨=Mxt*$?F\
Új«&zÒþeøÖCìZù_{h1}Àqåç­ø69 [òJÇ|ªê1pókct¯÷c2,vf!«ÅÅäÊ¹/úêX4@¶"ZkýD=}ï%µ_uÔö1hËk<ËÃDÕB_= uxÕM¨o)¹æô%¶¥ùo$áIñHW= ­{y
}Ü'I#³ÜßÊfb>ûØöåq..ëÃÓÃµ²ikèuTyÉÏsÈl$úõì#¿»Nì|íLP:ÀzKXèÜ5ë{,~s\më·9}"j³ìÎ¦Õ¥ê|XdAÇ?o¸¡}YAâR´Õ3VBf{S¬ìíCÀh2IxâÒo*%Í´ÙÚ}b,FþiÏ©³þtúlÍ"'+¤àtäCMpË)WÜU;]¾iÐÆ^ÁÛÔ8N¯ù)ÐNÚãu»þ½à3$5å7¿È,ßêúçLe\Ðgç)1Öv(8ïikxÂÌ:±Ü^x¾= ÒÚ&@ðÔ&ú­6\%Ò¡ÛÔöÿæs¿»DH+E¬B²³(É0k/DÒ¨Ò/¡äh+KýfíÙÒf)Z êÄì12îvÓµ9Øje8úõ}¦Óòåýeø¥Ô

WDUbecRó¿Ñb+uéèwU³ºpø÷Z¶ÖÍí&A+üY·¬·Ê!P=Mò+¨fAVLQyóqHÉk+Ñ#lîËu{Ú/{ªó2È¹Ý¼wÞÓ.Qõäþ@ûSµ£½'Ê*ÃeÑµy½µÏqñó½O(Eq©ôµ±L3¹8²*I*0?J Îyyè9¶.¶¬·Ãê¬aøª±"öÏmñ^ºko|÷P¼7§AËTã:/ñ¢u+e(m¢V
.åHìÌgÆë	Û¸3}<TÊôäeÚÔ$äºÝÒ¿Um«¾?÷¢á= :ÊÃ¦wK¿êHâÎN£h¸öWÒ³½?Ñº?NÄ£ÀèW¡»¢Üt+qPWuD¹U·ßµÌñ¯<A¹0{±<
 üS¶)eà/*¶½3@"æB®Ãkµ©´ÎId¥ÅIõÙÔ¬pµ°*%{(Ô]lïëÇuÅ¹p|¬AõC¸ÍÅìB2¸7lBìIÒS¼-Dê(F,,r[éPAÚà«=}0ý·þKªmå¨¯=MdußäsÉ5^rS= 	4ñPüÑó.Ôª1*Ö/«*÷Qe»rp¦îº¾Ä{¢kÙ:}2Ii½Qd!Ê®×^QÛÝ
´~ÕÙDEÙÎÕÛ>°¼Ý~¢6¤¾þ¢6^ç>Da¾fÉ4]í>¼ÞM[ô§®Áz¾cYÛîÝ¢åÖØý²8Qi­ ¹9^ÔLÚ²ÆÓ÷a}ÏO¤ÄÑÚ.>Ð¼6í¤áb GÄöê¯aúÜ^\p]­ái½Kd×ôÙVj¦ Mw@BÑÈ=M¿Bæúì³\;ÜÇn5H³¹SLÙ«.;OÎ^×ú^×õõ,{(OïÖ©},
oiº= ¾¢&¤h*Ý85BB¦*ÿtÍ|öe|®Dõ40±vMOPP>Úöë$Õ;(¾·¡7ÞvöaùIù}ðóãú¨ -Q® û° L¬²''l[9QÓµYykçäe?¾ <ì
Ë·F¡}_·åøO¿Þ_M»ÙÌX:ÝÆjØªª£Ê¯)¬ÖrOóY4Ph[«ë­e­3cnQesÜØ¢t^=M6â075ÈSøc ø¨êN»s®,øWýÓAì[â,AøüD1*µ	Ý÷es¾'c%ü§.ðÉøG|n_4õ6¨ø-á¤$ñ´5Áddµa){~9YõÊ%	kË²÷ oå±×ùu¾SÛe7PfeØí?Üh^®¥t"rõÅøsø¯å´ëí¼öXª3#ÏpËÌáx¥Z£¤ºnbo>6_àá¡=M[À!ªÏ¿°l=}á%5)wÜÊÓÄ¬6L@¿N>%?_eh
XìvÁL±$N»Cr:D:áë{J	ÝÐ®¿ëéàáñkKfP½ñ1
X!«Ì¢LË·ybZÊÍ¨X¸pÙ¦cªScjHëg F.=M£¯¢÷P&\Mðübedñb:\0*.Aæv¡±(ÈFPæW¯|÷¯¡ã$ÏÕ|_w4Þ#hM*ÇF©U)GªE-Nõ?ðñ²ú¬R+ðo³"xÁ(dá4R*"ê­É'¯¸b·zÆäw­£IV:zü s|Hõofù"â·ZO}þ~wÎXE»àÁíusñYS2FÚìTX·=Mé­ h>^ÌÄ<ß!n}m÷(w<e(ÔØ:¢;}áüÅµr=}­óÙÍÒ	K
+Òë0ìR1Å"£DÍÐ¥$­"9jh}¼y
!gë v}Uq
,	²Ø:\Ö3hBr>éHÉ10DS# õvmþì?óãciüKóÏDÐ=  ¬c±p	¾µ¹mr¡tø¨²ï?hyI=M÷¢+@f¢nI,IUooÚ<»pwx_# õúwBVØÚÍ5A¨ñc}|É?=MÁó¹¡óòm®Íó]H²x>)Ñê6µRðiÜéfNÀ³ã
l2¡hsåWÆsÇpµ û«êðei|áU1ldBüc2b¦4µ·mÞJ.ªötV	?}fá^ÀæÂµ±ÛÙ6E\(Ä³ÉX#Ýó}®¿nXG+YøÐ,=}ÜA«Ö¹"1c9÷ÓEÞ2¡³GN»bÑX;Âu¼°ÚN=My¤ì*¤ìþD½µ3OV'"Îò+Ý"ò°n^·¡¥õvXÊ&nz¡« »]Ä«ß¶pû®ð§dQ·FjÿGÿj®Ô#Y}ìè@iÄÕj´Ãïù÷ÔìÙàá¯$GNT¤ßGq$þûjABf:º´È-Ñ|@.­ +Áµvìò·¬t <6NZN'Qal|4XP×Ëy½|º¹±ðV9[©"ÊwbÍË]Ë¸$&
Y¸5R@pc¯A¹ÁÓ!=}íä.2ñöCÏüÚR'{Qàr¼H±7·Ë=MqG{iP:éR ^í= ðyH= öy1l5>cée:1Ö ªÀé¯ìl,VGùvÏQ±ÛRâ1Iä3ãc<×W1øJ$Ò ã¬=MpLc­¾	0:Õ©³»ðW7ì(,ÚT_VûL®Vda}£cËo%ÿëÂuØDröÃëðòióO[~æ9õzÊÂ£"Ö>÷aSUq}Qì©¿;Lz]HÌ)&çqÃ{Ð<F5·Lèqº»ªµÒú=MÑÐÒÃY#~®°Ìh"¸²Ã,°{äG0s½ä1q!¦
§sÝíø÷÷2e²j·BF3ÿ¹ÖveÒçO= å¬-"këÇøû­®±¶ÛÛz¢;WR£OeÖO©Èµ"ÍÆ©ø´¥bÔräÔAGlx£Ðð"Qå""{ÀA2AÃb¼Ê¾ÖÅJ^& ½X=}oÒ1ÍîÆÜp {¨³%ÃÙ¹KPL5vê6è ºçjKûz¼¶TÎ»fFnÔOÆM»([ªÌJÆT½«Z ôÉ±Ý´¢¼PîÀ/^f±ÁI¥=MZvmQA/ÿÕC#ËÕùËU¤H6×Rsv7ÛBæäÍ$X;×]*i>yr¤h]C¹­©a{He"jÅh½üà;*÷¾¾å
sZåÌü¨Í/	«k1¢¼}èPCUìU×Q_|¡ÔÂ²
ÁýØù¡YT#! (Þ]»®¿á§>#¦Ú¹²JÚ°° -<:Ä\}ÕÅGogz,QRË¯ê¹í}Ìäæß>	8:»A.Ú?Ô_A~à<·ÏÀ»È5Lr<8OfÂkÙÚÓâ)ó /Búº]9+êáúVÅA.boÆÏh¢¯BÿHh
ïÜ!~áÀ
A½×?+¢<"xz±xt#öiHà.W¦¾ÉÔ[*T+\e¥*Zé(e¸s½©½$}OlÀ?=M µ81©Ìl{"¬Re{@çzzg·ËMnå&VYNÂys1XfÒ1áçã¸î¢RGÙZtuFj= ÐõÕx^®xJ= òGy°ÿôí{
B¯]|ü'ñkÏàÉÀð½aÊ H²Í*lÉÆ MäZpB*¥ýáûÅ±õhõëDeÒÖÈÖzÌá{;¹äp¯gKØtè
ÔÇCÚüºÌmÓ÷£"ìcm»8t³+OòÞNÂ±
ö &,>QQ×O¢Ý§ðÍÍÑ¢»Ótú¯:¶jì¡Rð3CÓo´·*·åccÒf­]YPÁ²U,g´ª{=}ó&òzdÜYÔébs>Ìkðü[i·¤÷Òé-}ùMÔféIs~uIÔ±^Ù6ÜXöµ{¸ÖJÒ9ûÃÈ|-¤NwÝô.L	ÍOú³ÏoâÅÃ=}L¸£ã	F<Ú&m\Ô.ób·û¦]ËrªÚmyöÛjÙ¬£>Ä¸Ó(j·BÉ¹MÇIýÉýw]wIÀÈaGn¬M"f\ôì5¿6d>K^/ù·)bÚPåk>NÚÝ¼I×®!õÔì+õÊ½¼°ý= b¨)Y!Eç¯ëOè5,ÊA^¥5sÞ1ÁÙ.G½k_Ìí±Ze´ü´bëÝYî]M_ÅnZ{zccÌIàÿ[WÄ÷pJßÍDR(.-GBÈÂä<²|HaP·°ìöà¢P-ù	ËVKý9^qå1-k{A]Ç§åEoÒ/·ë·,fÌl
x ª­81ÂEÁÞlz"J9¯­ÀßPºh ­Ð¸ç9~ïQ*'ÿ-TÑ|@Ðk¨ÿ±¡¡pëºÅúUÐ|y0xwv°X*ÃËÃa¬Ä+!S%F!²Âg@â>)'
Í·ÔPIo	ýY@n¶¡ÈYo7koõA@)èüS³¤q¸BÝµ®¼%ñc>»Ë]"ãÖÇ¬fßA3,ÓþK6¤ä9¸è·açéÿ±ïÏSÓipoyewL´<ÓSõ)0U2f@X.kH,+ù¬(rÖà,õ7ÑJIõæö[|
óCï°ê·6 HpåÁ[r¦$88f§ÛkýÜUqi×øºF¥ÅÄRvÑÎLæ= rtüªÿTÄ»yÎ/ºÀ³=MË073HE.Â«Í¤Lý ÂÍÉßÝ}ý;¼¸Ìfg2m¯¬ÿÕcÆòW²³Áý_ 3ÎÝ[ÞL[é °üÅ­zlËÅï°_k5Îp/ÛOw²aDÎlPhäBI ª$²®¦uT6IQF¥å¹3ÓIG0»ð¦ç1uá}?[?ýû 0êl+¯Úè:¯G	têÃõcÇ÷(W?Ï
×?'WT0ÈðÊ(Xôìýë0;¡Yï$ë²WZ_í9µ8b´k1Ð5û£úì$Íôäð"[îØkhçÍZÙ±ßÕ¦àÕø?Vû¿ÑãÄ÷?î_Ñøß=M0_Z¦àø¿ÑÍãjB_A"b[¥#7ãbaÉ ß©P_$á áSã÷-ß[GëÏ º~ðõ¡ÊkÌwU4õ¯\]É¢@QûNC©MCT±é®%I?= Y5Ø8òtB¿ÞUµ¶zÛÃ*rØûXÜqrÅ¥(2'+Qq¾Ã-Ñ¦HyHyÌ¥{Ãñ ~3Qñì?^û?~àU¦à=Mnà3+ôI^	³¹ÇëÉ½P,eíZ/z2UG÷3í'/ 2}/eêôIlæ_tõÜéXå®É¸D¹T+CÌÃú\]¯u¸ÙF£ = íp>ð6ú¡iëéÛóÄ]ì<@îñ¾æÍæxÕÊcégTÙT¾XÜÀº5<vÉÞÑò~dÍg[¥C?ð;OD*.Ô*µÙ²+­µ¾L>®êº¬ö@¾«(Ð*bÖì¢dL<$²â×åe-¦ø6c.¿k}7²ZcÏôè¡à [l ×yëÀ
÷¡c(óÄ1Öä¾Ù*µÞñÞÝöçJ¤'¥Ç¹c÷@÷ò4=}c ÇçÀbÏ3eO"?ºq¸øDB6×K'åÙwÙ7MÔIMt'LAywò|ó¬ÜZË°:Ü+5á=M¾Å FàÞÉèlO²Bqs8ÓÁì¶ÅÝä9Ã\»á& zwy©·î[:°NLõR>[b*¤Ne
ÛÌ6Âg0½¤|k»öNÄ½ âÒµ²¡ 5Nïpd,¢XáÍ^âEò=MÂ´O(N¾E|ÒøèòÐ¤ð2b°Â¨X±[zÃuïõ{p­Çûw 'SÌ×±MqÒéÅ·¾½µìªÆER3@!­ÊM¿Íòr¦Õ§Æþ´ÌxoÒu5ÀQÄLåº5é¹ú´½B!­Lÿñ!v²÷'DîÎ~àïH#ýÜdàóÍþC³Ø4RTL´LÅkð¦¦LÅALËAHâõÇI@lMø¯Ç¨'Bp''p£á=MåÈ¯·×#¡xW ;µÌ®e·%w¹¶jélVT2ÁóGyhÜíKT[í¿= /É~<4ÙÐÏ·!Jr@üÑ»P4}¼×U=M<ð=}ÜÇÒ8SñêÚKLP:?ÄÚÎÅ
ÕWtH+9É*õ¯v++6¸ÿDµW[·²m1PòÄðó&Èí/F:Ró*Óþ;=}lvýÙ¡/=Mv6eª¹@ê¤ªQÈðÖ[Ód¯	ãÉ":ÄÑO(²Ã±w©¯[Ü®¸<Ï»§¦\Ò±p§ÀâLß¯J±ÃÁØ.°_¤ßÐ°×öÝôg^b¥aÐNÛ:ÝìåÐ\m¢ðñù½ W6U5%æ¹º{eV#âWSÇ¤ú¢|_qBö?H¯üNûÏaª½)Rî´&Å×»z¬d2G;ÿUy¢]¯|?Ñ5¥!{oQ¿W	.À Rj¤2ñ®©¸æK±ü\'Uµ»ñx+Cm_SÛAä©¿|Sp5°çNælrZòõÅ£Ý¤ox<CEP@Ð±2%©rqÖ÷1cCu;Å£ÊË½Ö|m¶1­ñ].Á²=}:¢ZÂ5vN¸º:ÄÖÓ½Y_Jø M|©n)ÒÔ"ì³øU³SÃfäfõl)¬qÖûZ[ýÒÊã@YçÝ§c,ZCöYâpjOø|?ñ¡ì¸ÅCK¬RÊõU_D
ÙÞ­ÉWøQ¿¤&i	,¿2JÝEÛ[ú"í/_;øèoæVóí6Ãq;Ý)lXÀ¶ p'ÓæA¸"XeRÞÐý¦Ôáú¸ÁUg0>5@¡^f¯ï´òÚ¹ÕÏpÓ[ãå#ézö%Ý	á>­¯aSä×}i/cP;0àIß^8:NÄ¯)ÀÌÕ|åtSÅÊÅs;3ÉÞr$ÄÛ>	Ý¹¼%ïºª=}[û@åLçuFª+zmJª <ó>­Kðn³Þ¸7(9D¤´_Þ=}¤¬ø[Ò*ÞHÕ¯®o0z¡,¼Þ^Ge÷Ò¼Õÿä¼è9þTÕ½'^¬,×3wIù±¿BØÔçÙ¡ZûBLYæqîRkÎÏÜ=}£KÒ= =}å¤0eclNãZð§Ý¸©¡ÉNô\úêÏzLgÓ¨2$IwËïXh¥Iÿ·:GpiÍ±÷Ó= ÆÅùéöJ ?ë>Ql¤-d}boýYÏUÒ¡èñ/)T» âúxêwÜ­ÀíÈFÇì+¿¤î£ô>nìL¹l8µØÂnyÿ4ØôhÀCAÝíÞÓüÎº:ÕòL{0ïú[Ù@=MòãuSxÒÁÁ0±·Ï	þ_à¨2¬øÒX¤¡!ÏOpVw9©¿ î~\0= 5sK ©®òëÕ7òú?À¬ôCö5ëÖÑ@âï¨ðOÅG±)t½ÄSX~Nu¾öda¥=}mZ5¶¼¶	Ò¶Nîê±y÷ññ§iåLý1Cðéò£ä~qúé«
££WK¨cöú²B÷¸<&¸®¢õ¿ø±hÓ´±ýÝL^W15¿äíÒ;H¡ý[@ÿBÌQÁÌ|I=}Æe&^ÇÌÕzú¿&÷MÙÝÐ.]q¤Vã%}8Eßzï:O³wQÚu1ïááÜ¯ISê%d^Sw'ÖP¸¥rã6¾ÞÝæçªVÜ2VÔñýÖÐ\ÄÕzVÕ¥z¢fmÕJnV¤ÊBó&,KYIRÜ¹n¦|¬æèV¥îñ¹Ä®"È¤¹<ýx]-søÍDC"Qc1êé=}x±¶ªa½Uphw9ByKi­áACbXËMnì-Dè¸ö-DÚí}ò+nÀ­=}Y§NõWÈp¨z÷¨T×J
ìêãî6½;tÊ à+BÈäwúÄXd÷VDÖ­úÅU/÷në= ~h^ Er[µB÷¾LÎó5±
/¥Jó§R.ásß¹õæ©=M?£gùv¿Ã0¼³&=}\4Éº«Ö5?)¸±E ©ér,UÿC»]Ô¬~ÙwKÞª ÛîµvN£OrOYã!'C= 9óu|þÜà
\d»5
Dù]mäz«Î
<ZCjVl¦×IF´VÂfeM= ®¶²þÃãjû¢¬4äésÊµ¡¦yÿÈ]­B®Úò£'BßIÒ ÏªZµ'|#qÎÀÚë°jGthS$«\¾NH+;4·÷¹KPL¤Æþ©²È.¿!9GÓ:±ÆÆI¿Ãì­û£hp= ºù©Î×â¼XÊíß'¥#(Xlº#Hñy m:EÌîôNÅ¶[ëÌÕn3WOæÖ{¬búw%öÖ´Ó7Ñ¬
½åÅyîàO#£Å=}ìÎúô mÈè¶JíC0ÅÙÁ:¶0üæ}Ú~²õôM= \Ö®&I0y³§ìUÜÒÃÈu6¯ ¡Oç.ï= 4Jc6- éûAÐ÷ÁÃáäf|áRë+AGñ®Áè÷ÂÓ°)z½tÛá"'= v« Þ@»¤3éQWªcOBÆÞ7¬|<¤Ú5tïBßESýË&½þÛò[µÕs^å*8´j.¿¼èÓºÈÉý
ÑÌ§È²
ïe9µÕ÷wV³×SZã¬èðÛ÷ND§{Eæa[}yèÍLÓ®ÛÁK9¡ÏÔi¼Õ²~ÚüúfÌ~éM}×lFjü·>xh]4_HÎZíºIDm{A÷2Éî|ªÛqè\±ôLý0áB=}}(B#õëûGËß¤;;R	ðNs(8D
xk©(|ù!@Ïüh]ü?éYÓ¿Y~w_4äÆój sç@âá°'$önÁXOmclß=d{­{±Ýr´<QºÛÖJú-àNÊÒcî³¿±ë|c*íÕivø?AéôXazÇf¾Ô° ¿«0ºjôÈ¼c±ºùwÄìïæ&õg¤êsÝÍeÝSÈÉQSTA¶IQxcÕÖ4¢z}©bUYÄSÀ¤Z´6}ç	ÔE[Xu1)î½·KßÕC9"8¹Ä!Ë÷kà¡aFãèï3ä´  P K2ïLÖþÄn¤ðá>¨:4[/ÅcÛ{n2fGÅI²0z2óù}/s)é	\M§æsefPÃmPvÀfog¢ö¥´äf = ûö#zSééëB®puÓvÆóøáùÞÛAtÜ5d<Æ'{IDeãLúm_³×"r?1\'x²M#,Ö1ÑîWk=MËQ$QÛ0ù ùIËXA>n[§.1p1Èó¤Ìó³ôÊïàùG¥9üæ¢ðÓÌÑ)þ¸Q­ÛM÷ëRÞ\¨²~ÑQôóYÚÀ¿m»êÝ$_!¾_tÜ¦äl¹ÔÏ{¿v	Çéo¯3j|-» @HÄ¼,Y¸æò4vxM¥¬ïgà\_³ÇËâVö'rÙåZ3(t:Tc¬ÿ­Më:1@ÐÄZ5Ø;9zÙ]­:B¶
rÊP­fa]7<Ê¨ûNEüío7ÍxÄÃ¨®õÔqÂXC¥Ï#»¸>¦ìRâ)òÍ6ÌÊà¢!Éì~Q*%pµH=}à%²â(èç;cÑ@» ¨àÏ*rP¹]£QÓ5U±2kÞQ"5Î2Ö¥íª?»cÅqôªÔí/îé|^ã¬8ËÔüb äX¦[f7|A*K§XµÇ±ò4ZÊÓUÆçÎf3ÜAô|3öÓb[\©àöoøä!¾u½¾Nî>kí¼nò#9ÃòmóÈØ¡"Úñ»%Þ§à^= SrÁO¹aÝ;@*ÐbÜ dÜR¿ª!º^ÝÜ½È¸Û>ë¢æìßçß\Ñp_ó |(ì²ü¶ì²ü¶ì²ü¶ì²üÖFbûg@ÿË13 Yç¢¾b½$àHì&´fP¨~È&amÞ{÷®A)	½ä4yåë a9ÑmÄvXxôrú³íâP°Z{ð=}zÐA}´RoH¢ãó= = e´tbºåVÑ¿ª%V;eÇN&Ñp4úrI¾;;__ÏÂWþï>³[²yÑ[¡oä+£>ä94æ6´tª=}U¯[M^Ó}û£ò!ñ¯µAu¿Ù+Ðeª ÁâÊÜL¢i@¶P0SÐ0 áKËãòk?¸|ÒÜwcqiSV¦µæ:[KKðêGGàÎ»>ÞÐ],®È[+*"Â§eejW»ò|ö~LðÎTHIÉÉÉù=M¯¯Ço¬¯õ]Ä¼ñyÃKÀ«\Ëª65^Sß<y*¥æ6¯»èsxQbY.¨8sÍ¸øÔùbCëù½§Å§ëûÍIjÀ|öBËEcËë#©£Ol¥³7»ØctùVRÛ+ÆW4 PxÝ¦íé²°¹ÑÊÄ!x¢Ù_\h?G®E$AÐ>Ý@ÌÜ\n84úXckY2¨;ºx¥(ÈÍ¬^§XÈý9úQq¾=}J:Î0pÙ([ÆI(¶ìAÛÀÅ¯üeÚÀ~fÙ@MgÐ[³1Ëá{.æ.¡Ð$ê¿RP û=Ml
yX¿;îÁJÜPNáª" =}ð·é= é°i$>ÆË4¸4d\´÷p¥¸ûÛüÆ7t¦ðÖlJ¦ûN9=}ÞÄïro-7j)®s\­DÑÀní§¶î=Mt¶WøçÏOï±×Y ½
$éZMGð¥kÌ¨¡	¥Ü[ZÚ r¤H?èl:xÄK§qº½F<»=}KC´xÇÉ@ü9Õö<5ú¯è¤i§tr]£ë¹÷K&ÝÈMCÿc=M)³óCey{1fsüó¾ÎßXû) Åhó¼O}kNrª¹=Mf×2¹ËLÙÆ¹<).ÞÔÈlÓ¦ô»Üâû[TðÀ¹ôjÆÊ§îiÓå5÷V®í$cÞ'/Î°í%²²÷ü¦§ÿ8¢¯®ë<:«À¾®ñzëE1NíÞyf460ÄHf¬j;ÈçÀÓ jÞ1³V&ü}O:Äl =M7¯þdîá¿ÌûcÜaÐ°ó(º¡Ñ0]µ$?-óSp¸ól6éþn ]¶7SµhbÑ3ûmù
@X$h0%	ÇM6À)té¾Àï%]ù^U(ÅOÃ¦P;½¢PÑ¦Ãû4äû-þI)ÝÃ¿ûÑ%mú,ûûE^±$tuÞ	Þ²éòÂ¹¢ÎDy=MÝ«CôæCU}ÈøâØíÑ²~¶ªì®§T|éÄXNÝ©|ÙÓñù¦)c5¡= ý¡·¯t¡{Ì¡´}¦d56cyÄ¡cÖ¡Ý¾¡Üá,5G¸dmÎ®1mC}=}r¸¥³K"[uX?:l©5¨y©6¤úxM<GÔ ÕK×(Õt´Ç;DîÅF¸K:S :ÎÏ= ,ë=M@²]¾h«#r}^Çh½|HNyR$Kù+ve29ÇG±>= U'È[äp½³ÈÃ{G$â&8²ÎSZéP<!ÚW°xà	
{|nu0º	É:u[¤·¬³Õ¤	7jí\¿® É]Ò>ÜÆ8{e¨´Ðûì'n±ÌùTPjÕÍ"(ÒT¸BÙ]%	ÝqW*HJ±´ì>CZ´Î<¦]/CQx>Òy§³<âZ9¢¹6òa^:'á¹L&ËÕ² Î-wÊ½ä;@g<îÇ8Ô£ZÉl$qOý³þÖæEïüá|:åZW÷S³¯Gó[¥ù@#÷ÏWkÕ*°LáYìzcJ>"Òoè}ºwvuû¨ÆãRÿyßÔ/-fªÜH¯8G= ÇîugV~èÂ®¿Âú<þ¬= àzf¦ÆBUZJ7X¹?¤:óÈ=M#w¢Ó,¦ÊÖí'ÉÌc×¸­çlT= ªp¤wZFè«!5ó¥L¼ ÌÁàÒý}OÍÅd´üP¨ú¢)[OÉpû­Ù K;âÏQ;ÿñùáp\ç*t gyûa=} 7ór¬¡ÏË*÷·iOËö= ³ç31¸p'{úä¦&G»©i¥p¨éÇü2±åÌAOåÒ¥K"m[m¤Ù(PíUØPÏÉ#æZËÖÀ6ýÿ/@3és¡Å6	÷J@5lIÓj0¼]M@Þ1lÑ¾IK°ÄOù¥À=MÆn"Ä¥P{BÌ)meû"òÙQ3=}ÁOrÕàf¼BíºöûÊ½PG[À§
ñ¾Â·4¤PÍv×eB*ü&?â&LfPòf(&õmâM^$&$XNI0rÇÎ^\ðãüdPÒùLHÖË+H\ð¼0R³¼õ¹¿ÿúÛF«ÔDi+^&,ìØòÊ=}Ñ	h;NvtÜ þX¨btÑýüÑ¶ÞývV°'r¬tV(×ÿnÙ/®i¶ñuìÍ	qëïq%èNMøêÅE²c2J@1ï7N¤dÖ JdÓbzä¢UZc¨fdo¬d=}Æd¹Õ¶c¾èVdy&¡ÄcâX>cmt!å "JUÍWu#vÈ­%Ö@¾HïüktC÷ªÀò7-såÊM A]¬E.
K·îu RBb×Õl «Dta±:¥ùI6ô¾¶Í>¶c¬Nfü9f|Õm}«ËúmÓ$8ÙÌCz|F*Í;E¾Ì·r¥zºxKn6rC±Uä+1ÕalZÚuÈÝ£É]FÞtÌ x= TZØî²ì³ÿ¾½L=M:j1u´¯¯|§êýË-Ò¡ZqÀ3È.©½bÇ|uÜþ)]mÿ¦þeý"ò:óh¥ÇzoÿA%nvx0z#RiYL \®NÅ¯ÜÒÈ1ìüÈgzÀqêôÉèý¦zSÝóg{c0qqôÓ#(Ð,©7-×)Q7,y|¶±¸6Ê§À#´#KÿÔÓ,3¹Jê,¾)RrÐ|Ó[8«º*=MÖ²ÿÌbËïÐÛ¢\Íçì¹Tk­./¦ùÖëT,ùu!Ö|<­²¨~öÑÒÑ!î±dÊøóZÀ¬RrÙû¨VÚM²üV(^Ò\¹ó~,JQ^DL7ÝgyØòÉ¬êÇoeÏö³£>pÜÑEÄé8Ü= YÚ#\µ^_,¾'J:ð¸8!>Öup½éÑ1$]qÐµo½¤Ñ.JB¶Ý¯:¬Ê­>ù×4âna\0J;=MMb®yW0dLDL2½í2ªºB+XæÃsT#ÖLGuÉ?V=Mý[Îc>É2ö\¾ôN@ jÍWÛæQÑÔýÓc]5#EÓ¥cj\?v³ömÕ¢Ä\Ü0Dß¶ë£{ çéýkÆM"²ffà5'fÁ¸§@7³Z¹lzÉðÛñ4ØÓ !nùÀ¨e°jûbJ­BàÒP1aÂ0ÏBÅö+ÌjòAÆ£%+%y½m Lý]vAÆ2÷Ît #måêàYÜøÝ5;§'UßýEgwäÁQÝ33Ì¦&H7BüÎ^,¦Öêû/8¸Kå¹xhº°HÄ|AdcE
'zlÇNö¢®¤Ü¼Ò¯Kþ¸ÒÁËáÓS¥-u@âWº¡üÙº@À±dÇ¾Mð[òö= Å¹B.tózüÏMkÍÄAavòeGBÚýFøÆaV;Ïª][ªõ¢,ãN<0¶ôÒf¤ËR*pR¢Ü7«SfÄ"VÃÏÂáî·ºY¡ò´Ò¯ ¾ê&PÚuÛ·vÁâJâ>K¾Äê¶Õ]'2×À?pþ·ØZ-÷äÿV&ß5ä¿h:ÿ=M½îc£ç²åçERa@w÷k*Ì!Ï¨ãÆd?=}«â!°
óP¢¾ë]ø@´í¦ÿOSümùÐáåÊ¯3ï= ¼Ü0ñ\.%\8¦#@%Oóñ1o2ødË°°×¶ù¦ÐÔ"ËÙOI= á~¶¯Åá<ô¯ýøb¦÷·ïbÃÊ/4£?EÞ7Ówôj®0Sõ:ÑBð4öêÞ Pçxðf×¿Îkb5%ûá£ñffðI#_nñº¶0Q1hZ)'	téíâ3§u0 /dÒJ3ïñ3Ç]$3 ÌéÊú¤BFí4B3ìdtù%j´ç0Nù8º³÷T3ì¬êI«1¢¿h9ë>ìré5@¶m¦m ûÌkùRûÂ§~¤¬uÂvê&tö¦¥?mf°ûvfØ9íÄí|ûTÚ·ðíÈmqCízêûií¦Êû,xû*ÍP¨ÀgW§É¦!mÉvûN¤N¾R;×£@Ý4Þ|Â:×,&$¦)í¾þû^R;ÅÀ¯ÂÇ1®°Y½pBÕþmQp(Û=}ó³«0ÿù¼¡ð=MòøÝÄô##ºá°&0Ç5³IõÛ¾PÞÞ'Ëw»Z¨Ë+òÞñ<5Vyð:	Ì\²/¢°3¹IbÈ.Õ&é,d ù½*Z¨1'C2C®M×§ñ½sLº r»=Mj+rªtÄÚÿH7ºP$*Ê	Îñ2²/'®#ýÞÎØÑ²µÑÞ&ïßeà#0ßzLºTÞ¬LLºLºLº,í[A<Ú¸*Zè<= ¬±C,eÔgôZ¬xÜ]Ã¢µdfÆÂ¸fxËâ>º;7ª}çU½F¢+OùX\|"9fö°¹
ÇÙµTÛÅõñ6º$1<æGÎPÑûÔÆ=}B¦Âü*X%½°V>Æî¤ÞÃRú#G_óLÄoÎÛ)s%GJbýlËýRy4H,¦ýï.uê[ÓÜòCËù#ª^drÕh÷9pÓå2HX6õìÅ2¾1YQi^µ2= *êÔnT±¯Ú]	,þÚÙüøKõÝ|êÍÕØ¬=}ãfÏ§Ð9= ÖP´\üÃáA2Áõ»mÚò/RþA~û#nÁðÛjm¢R.ÂÓ²Roæõ.cÁn60|Wâº®»= Ú\»Ï÷Z}À=}= Òi]^£nä>µÎæ¹Ý ¬YíÓõPBräÝðeÞXPGo¡HV¨Á rÓJôÐ%øíT×¶ín=},ÛzâºYW²ßaCc+h®ëÙõ/ë!Tlì{õº×W{ Ê¿iÁ)V7NÓ!¹þÑ¢Ø¥ß'þê¥õ¨/©é¦Æ|0wõba{tgóbClÆJåEE@Ó[=MeÒPE6ðá¬*ûû%t8>b$5TÏ·ºç8E>L"#]æÝÌeÚk[ûØê¢´½¨.ñãîßtßßåLÚÚRLºLºLº¼ø°q4Ü£È  Ûÿ(#b8Z8eh|=M®¬¶é³³	15x<­	Kü%©üTñ©7Y½\Oz¯îr®Ü0uü'´Ä G4ë%P¶/uíBÈçåæk£Y°G;¥¯^µÉË¥RÙ#Ë0Réæ<GÛFSÈe«ÅÙm«z¦ijêÏs;£ÜÖjØùÙéÃ²6z\vSø®2â=MI$Zø66Þ	E¸uGVÂÉ®ì³HL¡SÎ=}L¤BÍUåÅÌÝ¸=MM«¼¢¡w¼nµ ½¶þAÀðN¥;dòûÑhÆ¤²«yQuÁR×\= Lº=MÎô=}Ä©ºÊ·(¹Lý¢ DVøØý&4ÍÝÖqý Ì ÅýPÚÍBqî Q¤2#~ð¿¢¤>/=}ÕaÐQ^¤'¢¶£W"²¹Úmþ
½CÝæ³&^Ãq¹5S^Á,¤FS±Ã
-¾Ûm Úþ¾Þh­Ø>CÍÞ,¥eµÞjÃÛ^+yGgÒ?Ýù2=M@¡ºõò5w±{Be< @õ«Ó¤°éTêJÍÝ Îº>¸ðÓ¯}züWW°pr-»Ã«x¼=M7MPD¹uÎ è,.óöX0¦z[¸vÂÜ/ýÌ®Àà[ùû§Ëà ÔìEGïmd1û¥N¤O}¨&?=Mú(Só¶xøb#Ü¤Â7
õnýL0áLhÖpµrkdÄ3»#H÷gD¯u(Wõµñ¸(Åotj+ýæDÒhr
?! i$0=MEdIèâ³*HµVÈ\
§Í>(´	f3M7ì&³QR3üUBÉø¶hlKx»£º¬c,NZE
2ÅD=}õSÏT05*OõP³É /&#¿' ¹/+W9;C=M«ø
 Sw'ç-ÂdÜEqaÓãÀsYÏº!9/yûsð;¨é,u¡Ï¨Q¡
Þèaæßßßa|l¹E/z>º¬OLº+ºLºÍçöV.´àòP&=}Ì§0AµUÁ¨J ¯d>ÿUÇ)£©cºT"ú~C(V0³lxõ Ò±Ou= YÛ}¢;,<ëÉÇ&ÒGí´FÊ/\eJ÷¿³¾_,ë¯É@'Ë&"ÑùlgWH#º)BõJ= èÈ¶,G)ÇEËCe"otº¬ÈÈE ©aUu+8G¨2â
-Á.&JÕíÀô;YL¢ÐQ:¥»$¼m¥2U+ë®íZ{<û/O¿bh_2ã;K]_o~c[õPÎmghA9üòÂÎÎg¶&:wÀ£µí­ËÇÆ+ÞV­T Áê°pS»Í©7= úÆPrâÚÒÔíäýÇ|Ð?>_	.!lýÂdÙö	ØZ¸z<Ö ®³ö¥×QÂa;­ØÐ¹®~aôÝë°ë>ß}åÿ-è£Q6ÿKa}ïcªÿ½õ ÀP÷¿ñ+Ñ?=MÛê44çn®cÓçDª{/uIcð;ø¥·2@ëTè&{]¡È:ï= Ü= çå¹#KCÍxïþ¤TóÀ¼8lE¸¤G±»B/,l Üe{7y¥9mã(ûR­¥0ûnG+l®Á¨è.¿ÄãÝpr§Ï¬hÎu£¹ý-!ªxjqÐw+dn"2g|!&	¥AÏt¾Hë|seÙHù\â±XülFÈKÒ®Úë­?lV¥CQÕ-H=M8Óýq$ÇÄ3¸KÎp,¤KÊÆ	æ®L3¬¤vT*RÑ vÃPP;ýMÃ0Av®û8ÑØÈ/káí=MÓDàåýdKÉ>§d{É5#SUðÄji[=}£ßÆAÙÕ¥?.ø)On@¢cñ­<	@ Ò*Xsn*H>¥y¹c¬D£
jJ,QCz©°Ü;-&ä	a¶þ
·Ë9hñZTv=}4A :Dôêv3PÀMôªk©¥TQ-4ò´eg¿ù}Õ eÍJwL2ªpÛ9,¼È9+:´P´íî(ü}
ÉXíú¬YÊ8µ}ºÉY¦6= Áwå£ÜùwM?ªÜåÃ9l;ìJÃ= pªúXPpÆLyw¿¸£Ñ=M+LÐ?òz½§+a6ãDNèä
 Ï.!6psXx1ëu<Ñys= CshC[)vÀeÍ)ø®¨WÐ,¥4R±ºúÄ.vr:­qfQõ6oË|?6äÆ
W[ jé­U/ñÎNq[q²tN6Ã±=MÞøïæÇÿi]³·8UIºfjLºLºL:¦¸üÁiÛ¾£ ÔU7º@¯Mfü9ÜÙªË=M8êëÎ³RÈ¨ÌåvåFÞÑt*ýâá5tÏ÷º£;ÞÌrÔGY¡ÂÐn^\éCÔüÊ2®o=}þ~Û2\¥Ô¸Y³FÍ<~>\51;ç/KG9*PbÁ4>¤t¨iÝ
ôNÖQ>0ZÕCå,?¬y)´6:H!ÛÚç,}¸yJæLH9°ã[²K'I'{¼ï÷M'lÀô"e<ìÙ÷«÷"û¢´eZëþ-ù­¾ÓXM×Ý´/	pPå*x[u¾0u 7Í5N(·¥Qf&þª¢ðu¿uÁêÀJU7ÙüNèLÑ«1¿Ä°Nj(*#Ãó	ãèP!Ñ¡e±!+4@#@VRÀCæ@B. !¥ ¡0¡²(!¸!ÇA ªIÀÀ@³=M ¢  {óÕ<ïý>ö}¾ò­ôðé\õÝ<®ß"eàódLºwNLºU¼KºLºLºT¥Ïî®ÑQÙOÕÜ?.2÷J=}yeÿ}´httTX¶8:9 R:xÑ:¤j7$)±cÄVt·6¼©=}¦¹±)³³I¼±9·µ³°¼´¹¾²y²¦Ii£¹{ÍüLýF$wC4|Ily ¼H©XµÍdµ5ÞÄ54ÃùÍ7N½8Ëõ
´UJ§-Ê©M
­ùÕßVýÙýåüY|ù|Ñ}ÀÛRÓ×XÖ$
äÌÊéÊ8¦."Dd¾ÄmZüt}­Ðgí:n~°ÀTbö5PÙ¬

l\éò½¯¥NOÎGN"±ºRpÄTïGÎ(ZÎ&Å«ì½á&ocíÎcbg!j6¤ë»ûyåBú}å<}ælë
Oû.ð{Í-_+e9Gb½÷dø7aÔ·d¢l*= ZWkÆWdV×_®×aN×Ý6Æ½îÐ/<=Mú÷ÕßSßjÞ.© ÈÍÖ{ZÉ
á9ák+ÃÂ´¦ßCöetG*¦GæÃbH;s«å tªHÌ¾WÔ¡äAðe]ü0õ	è	#¤1+@ã â_÷'óä¹LúÒ¾¸LLºLºLºtxæ!ËI°¨Kmø$J
ÕÏp²Ü¼fä'fw}ÅJ| si÷ê@DÚº¸b ÅÈ¢×:6oÈÁÝdÝYjUx9¦ÇJÈøÉ¡DYq]r»×÷´»×h%ÖÝ(bæþ/½Ö®(&Èü|HÝ)­þØGY s=M¦¨±ÀD­5ÀéLiú°ÀCÛ©aí¸¯äæÁ¿SR,}Óoªnùõb·{­jòhA	t3ÊÇ:0Xtu¯¾ütÓÎYÑ¾!»|y²&²Æ&¦Iq¥Ö«òýf®4'z7âÌÔwm½c|}:0Dâ8Ì¥:\¿Tï©&?7Pû,~a²¨ROXUð^ø=}= X°TÎlâÖÏdOÈ£îÏ±Ýøx2 "ÏSÓÞj-°f¯7ÝóÈõ¿QÒìí4¦®Çª= Z»ø îþ@ÃõfÉH3Ku¦&8jÿ/ìùaùäRøüÃÊ«ß5}%s?á	×.7E~ÝÞ½õ{Õ·KÍgø­Ç{PdÛ,î3êY@¯æl]¯+IãÂ;$í~nAóýµ£Î=}SKñÐÖóÃO@BDåÜxlÛ;ÛVßY $¯=}i¾¡ªðn	kEµÂX«ú+äFîB<3»=}Ô?EîÊå0ÑSã.5n"Yñé¡ZXýù\j7çýßßßßéEºLKº}ÌÏpLúLºLºj¶rM¯y°fî®ÚÑþìGÿîµì¬OçíBÉºÀÓÍñþ ­´nDb	¥>Pár	qxÔ2Gò+B>Îø§|¨Ôh8If§TÒ·ô~võA5g®vO\¥y<vPM¹ìÙeîÊ¶
L îD EU£K@bG
|êÒHæ®V[²ý56ÍÝ]ëüC«·¢ûn¡¤¦7X×ãÐ"-Éî~ÄØdÒ;{XpÅ±*»O¡v¦¶×WÑåÆF*/»ÿ¨m/HDY&}}ôð=M4¥\o	àI[è´?dõ.½¥ÏÕ<½;òÝ_÷¢Ö×Ïßöîè[Ïga¦«´[¡[të3W%«R3=}/ÐqÒñ×
Ðùþ¨×*¤'ÍüÑ)ÎøÝ= ¶1	Ý£a~¸ÔÕê[Ú©÷ÌNcw]ÆÂî¡[^ Ùö^ÁîjÝ1Ó.J²1f¢ZSð;¯Âp1.ëwÜºïV:ufø© ²óhÅgµ9ÛM	5+^F¬Dêú³K9H¦ËðíWQC¬8Íê{°ÝÎ¡®ß6Cª¼÷¥bö:(pÑÊcõÙ¹~qÌà6èÃ¡ÿm%å
ãô@«uç&É:ãV"½ô¤£Ç
£±"mHÐør'ºp]'Eo^éæZP= SçS¨#êªlãêQU®"
~q|dKY=}£ØÏAUm	Ä[øÌQ¡i
;8$ùP?ìÊ·U}BEìIHQ>:=}³iÙeUÉÿrp¼ëp2ýéßdJEL:¾¾Kº¸EºlXªLºµ¼ Ú 7 äéZ&wBÙ@ö·nLÖÙ\Ûßû!æO>Uÿå2æUïÁæRDÝïÝª÷¡;dwøe[¸;ÔfR¶çSk«HF®hÏ3#s5^01C¤o{mFÍIñk»	(CzD=MÞ \Dókü¬²·°g\ù¢¿lB¶õÆP+rýnÅcè;'}_É#£V-4GJ^,,]é(*Y	ØÕ²Go}­Øw|b%hêº0¨)y¬ü{öRX'¤®Bb¥[íÿo<hêP±=}£ÂjXEèÄø*O8)Ë¤DK~{0Dª¸ÃaÖ6Qô ü·Ìy¸~µOUÎ9)¤¶ðumÒÔ=}¾¢úPMº§åÞ,+0c²&ãs.o#i= ýz°Yä¸Ì:Pïº¥ËLgKæüã)Ì£?Ã=MáV¨@ýÎ@Àw*Ë"?þ®Õ2ÏÅß%æîAÄï\TfOÑk|Åðùû$TÄ}ìm.ÙPã­÷ÖÙzî~Á¦«²MlUÓø9­A
^íÊÆ|Q= öúTðRª*+]Yxiâ6ï}l+nqg=}Ä·Js{-Éúsh½Ã3¤,bMµÓ¶~»ÎÏ<Ñö½B×oÚ=M®Yæ?ÛïÄnwQ+uQ+ðp&)}ìðn8HÞã¸..Hv]%ÏuÆ+Z !ÀvcÆÛ¶ÆôÐõ¸ÏÍì*¾Q¾Ñ¢½ðÐÝüí,ÎOsX.S©Z#V]ÝÚæÅ\£©×&]Á·z.{N×caÓFñ2H¶ö¡^] MpááêäÅ*	ÑöóPcWñe&tpé2E¯åô»3zi	&eÀØ%l¤¬I#»/Æ\mÙþï lyZIq:jü9£gJÒÏjªZðr´@Gdí2ÉQ$öªYkç³"J»ÔHyDhààqeø±K£uF%7¶úÄeX¥;H¡±ò%ÌÄ2õÂqø=MR«p&RäÒ§ûIhÌZ*óØFd lô ¶øuN¬Ô²C¹OR~#éËÚ@fÁéZs<ÌxÂiâòÑ+®pù}UoN|ÍQÅ´BöÃú;W^¦ôº6Q¶ìt²ÍÓ*P&Ìoæj»Èh2o>ã=}ØÄ¤ª½ÇWZÂ£f=}Fþí¬Ô¤¶¥v$²Ñ¼Ó
¦¦^BÝ¡BÐ|Ö^Ï!Èæ~åÞ£ÑÂ.Ad^Ñ¬­VÞÁÎ¾LÚlv»þUÝÁÝ>+JÝQÄþ
Û÷^¼þpñ^£âw8ïmj= ¨èÃÚ¸ÿåFå R	wc³?Õýî cº&!ð*çÇ?÷þB¢{$°Àk¹ú Ï§ç%ÍmC1WJV%Pé¼Ì°å&\:ëaA§ºñª 7¦Pÿm!W½×¦:	= SãSãh{Ô*Cÿh ](3p+Å¾Cñ( ÈNé±×ô0 ùÛ±oõBÃv-eÿbÝøo©«r¸z/è§RRîá½q¢bûÅû{ªÓÌX×fÃ þp[ÝË_¤êj£V.ðNiwx¤ÓË 
cæ*h$ÌOøñª^ûxÃQ­þ¿SÉ~ÃKYv-6Pi&FX|<lÉØù«QJÏ7*O]xvÊGBw+)ÉÀ9âªùo°gE$ygIÓ-ÜJzxQdìÔ{W·©b¥5óDºKMÂ[ÌóÈbà®pÇÉCÑª=MÅÕSÃT
Ú8Üft¡\¾ª»Ý\+Ù·¦v]!a½!á¸î!a±ÿ  hàÞòãî_Lßßßã6¥Ì·Å®LºLºLöLº½|þiÚ@ûÀ¦ò]ããÚ²F&ÙÄ® ßî)ä¿÷üc²à»ôåò'= ûò'_gÁDb÷gÜFb×í;´¥äwôñà©èW-_>}_7ïDX Ð!§ò1+	7XðÐXA©jØ-«;ñvr¯S{ã\cAª)È5iÙs:øª§/npPÕk¡ïsé@§ïã!÷ôû)qSüð©¼ÂóêëB(]ëì«°ØdROÀb¢P{^¢xÄl?&ÞçQÖ$OÒFãî{pÇü¨Ô<p{Ýù¨EJór&°I:ón0Û#2<%rÕyòÉ÷ylÀÊÉ÷ej ÿuà¬BXuÉîA¸yùf@û´Å¦ÂEûäPÐÛø.ÅkWó.´ÏãÉ5)­cã	Å¿óñ>	pÖ¢ò¸^p= dqØqW³hpZq'Øu£Y*Ù¨¹s+³zCY1Gt!¡ióÉ+@)I	ÚÊQJ-	ÎÑl®t²W l»Hï²Wµ Èo­«~È7Ëø{Ëu ¬ø{W|= (x¨³õx<qhÍMLñw4j2§§ÁizÒzdæÈÙúffî<Q7 æÖjûÑÃ3IÆ£¹JQ%$3  £÷ä$n
GÐ. þvq sÓ½È
ûôq	­­2°ÖiOz©k3Õy>I¹7KÌÀÔùìnw2ó¤4j.j7¦,S«ÌËü=}ÊÇ~ÆN|ÆÇW0.u³ªñåEîVv= ÖåÑt%íW}p=Mvl÷DýsWh¯<Ð*M5BªEzZ½k/C gä4þêÈ:ç=}7tED0L
4:ØW©©o^5Ý¸KÎGÂÃéú@VKsi²{| "ÌëºBÚZ4Äí1ù¼ o;æÝ-Å{§H¡¨}:-f'	Ì¡¯dTj{v=Má²»{ÀE³¹Mí^T27Â@"òîa8ý	ÅX÷ÉÆDx¬ªuU=}µÕÔivuAþQ[;ÍÅÂIþ~NÚGôÝ~ QéáßaGLºU|JºLºLºLºµ¢ÍÏZ¿cóÑÕàÄåGÞãåóñ¯&ÿrá]öo59 &æèH,§v!Môòp2¥?ð,hÜ1#AAýH£«ø%$«FAdK2)§».aSbcmnë¬D#)fý1CDRUøiu­So°WpkhvD;({¡0¤E§¨Q1­~Qu50?S	W9 ºéM0/q=MIêÙ	¸tVt­&Rôl¹W&$	Û5ÀE"¬ÊpÉ³´sX7 ì(AìÆG÷7"*ùY,¢¼9=MkµqEvuñs
'¦zmµ¬¶ÀÂ¢üÌ	ÈMµ2H}¿åÍÉxy¤weå¹eëwG¿Ä=}â">ø§1¯'.pêÌlÃ}BÈèy%Ã+³/x×²¼£Å¤kÆ,»ØD!2 «éx\«ó9@¥D´Ýx¨:¸¡d¸Ü:HÀ·DêlÝ8w1¨©ìbtS\ó8M¯$
Þ]86­¥/lléK:G³Hú··2»­Rh|>ÌÌ[z@Æµ ª>¸PÄTÏbà æÎ¥ïNTÃb´È|ËÍC¸¨Ã-;*|CÊC¸öôjwSÐÀ×öU/O°z!»»ø½º,p$M|OÒÊ|ú(]îyYwÍÖZfðJZÑ²¢Ýñ=}3æÂ=})kÖñ¹ÁDÁ,ªÞX81µ¦xî::þ¸Ø7¬&ÌºÅÞÖÐ~m]AòÛW×H]¢.¹]uëÿòåõè/\3_JâKï¿ÁÆßéã½§;6ï6ÞÿHöäxS'uÆ Áx"KùÁ£ÖÕ ,ëPNRg6"cf'>«·@Ý¢wÚex«Ü@­çR«iðçsè$·!ðuülÏÜHc¹øw	#Ð'Ç0íjÑMHsx&3^ùDD÷¸ª¤êBkì£7¥eäÅÍn°Ø=}k¹^B»ù¹­:{Å¼ÂëzùFºÅÆ¥Ï­Ëè¥3,ÿtWü(¯L'+ÌÚòkr?Ö®ãöêÅA¼µË¯ECºµç%-@wûÌ¹÷9ºL|¾LýRLºLºLÖ¼D¢À«×ÞµÛ®òÞ²ÏÈÞ©Be .ëµ÷å2ùÇå6ùûAÏºâbÜ¸+4ðÎy+×¢CXêrôb,¬°,I>y±ÁõÉ8Ï$FºA8jbBm·QA«j¾²ºCHp, NK¹ZºþJ2Hx,ÜtN·C)Âg"¦í¤Rw×~"Íí­ïf¸RûmNPRp.ûmEVx0½¤W¼ºÖ=MBv!|<9nQ¸¯Ì-véö»c};	ÆÓ§1 Â§JýÔÁWMÎ0Pw&¶ýZXÈ0Ñ&dëdjØÌÅ"~¿V~±F?V~B\Ý;ÃT®Ðè«"~CxáÍõê·4?¯æàÎÞùOëÏæ{úýÏ¥{_ÍúáµûèR¿YÑoR"sîÈºÃb®"MÝô±!dÍõÑªo8R"Nç¨\ÛÔ#)«viw4ÁvîýÞó°©l²ÁÝð"%Ë=}ûPVJ#Ñòð®M%{,õÿ&+3	G|w$Î¥ÛEyðrX«ÆAlkx
EÐÉwXZAe|lÐÍ¤³'|*¯ÿDü= Y&OÃú ^ä^( Ö-abãòèåñãzãlîèý;óë\s%H(;*Á,¨XÝosÒD:*QÕq»û 8<ArCº	øZ71ÁqÖâ¨ÔsióM¤	iló/kÙ-°Éþ¤¦p":¤a=}i.&í,4[7^b¼¤&ôN%,Ï±IEÃ±ë
p4N³[6Ø
¬úJ¹h½38¬¬H¥±78*Âw®¬>ÖÄ=}HmDG)ªe¤à'çßé¸LºÔLºå¸LºLºÕX7ðÁDïEÃõóö4óíµð!yêäêlÚè¼,Ç%Ç<''5W<7O'^5^ZY3Ø=Mîó&0Q¥6y3eE5¥Ä4¥ö6a±u1hñ·5¸°<H/ØÂ©g)×H)¾Ø©ô),)¶¼©Á©È©²J©¦Ú©Úö©Ün© >©³?P3-B>PYÂTUJàÂ@è!äB@ìÂLâJ*H&¢Yùåùj«w±÷°Ç²¯g± ÷¢'Q·W»S½·Y¬'V®÷Ð³Ö¥§×¤GÖºwýCËhÃ;lÈ)ïÅÃ­S­­Ë-Æ¡-m1­jÑ­sI-­¥-Ì5­¤í-xÍ­- -<VEmO=MlRáFdõDvÄµ$øUðÕVmª-LhfNý¾~ÕËÞ°ÈÚ¼Þ¦è¬ýá¤'bÿßôºL3KºÌS¤LºL®¬NZ×¥º«Û´ò3Úæ¢¶>ì2ø¹j@V-¢t[e&dì®)÷ýu;C·0¼üe5ìë8yùNF½¸¿¯¼nÀv= ³Ï¦bl×+~M·&"·;"$e¨ªë&6ø£K¾Mº/Q£@"ÝÂeìpÆëNøí=}kDQ.ýùí\ÂeôþëX~bsj}TCÖ«ÒWäùÉdùµ&÷{ìäÂì\qëÊ]ÿMÞ+WÝ%Ûsq§pe}}~(ñQïQòÄÛêïnêòið*ñt©ïpÄgrôhÝ4g´hÒhÕ¯Thxìó¶w7½s'°awºiÙÕ YÍUÑT U}ÕÿÓYÓÕ½î3»ïÑÆçaS\ëPY{Y|Æðï~ø£Tm­µ¬ «ÿ©]7!=})K=}
h{hÖJg¤ÊgIúçl£¬#°£L#üÉZY¹,[vwn×Ð_Å'cý±k&3Ò0ÄÄãðRqÇOyQeg*.['C+S¸ÆJi-Ã($ë,"ûZÖgîÖèæ#£"ÈðÐÒòÁ¶£®³¦R´p_öcÂ*¬ÝiÞy·Õe¿:Ö¥ZÂæ¡6^3¬.yÄ0¿êÀ¦ñðûçî¸Å'T±K­£øÈÄY£èHÆ%c¨ùVæÐ/YX^xÆ$CÏU(Pþ¤)4>Á³Ó²=}×ò7ß2±æ	-¡.ïÐ+	äæØc÷î/6ûI÷)%!{Sã"ý(e'Ëôþô$ku²ñDhðQ/;ZkEr$Q,a^°=}Å©øPusPy Ù©ñ~(é¥ò,CvÂÑ;á$á03ù)þx=MÊÄcó&hosh#¬kp-ÕªXÎ£,!01ð8spù±/9*6ÈCa«oX+µ©õ¸æÃw{pjQ,Mª\XÃv.Ñ,{£$»¤2[£.á'a3¡!ÉÊÖñaWðgÿÐqÝbµÏÞvæw1¾ót<l.©ö4=M¢Q Ïßó$àKLºM¾LºÔLºLºLº+Sa6RÌÍQÛGX»pR«¿½ø w®¦GÍ¿FX~Â£Åþ5gÐ*þÒôhõôÆ¬êJ¦Ð9i×&W gÐ¤+Õ+S*9hü¹­ÂK8Û4OÜèJÜx«ðAD1KµYDU·#zB¡3¸îu´À®¸ÔC	vLº3 7IòºÎ¼ªõmX%òGÉHÁÀûIYgQ6/OØtÝÆËJ#J®ýÅü¨R¾Ù]ÎLYd>o·Z¹ÅdvÜ³1 úDPDsÔ"r¥eÉqÂ1)pn(1 }õV¨ýCÌ*vbGÄeOyeã¦±²¨Hóz³.ó/¨~1ëøìÜt¡
Ç´àÑ^C­n= ¡yÐEñÊVÉ1E X=MÙö?0¤AÖ=MbÓa4§õ$N£GuÅN¢ôOÓÜ=}³åÐW=}èýáImÉ½(+¨b(ÿÃU[mz2MB¢£¾Wc$Â}@$¿*óé¤´òþ Æ
}³Ü>«þ{Võ¥@+gô$GM¤($ùÒD ´©bÊ6£8	g¹e:FïÙ5êÂsTµ&îª	ì¯®÷eÆ+5»ûq uçý@bÓÂUçpV_+òMOd¸VSYAÄþ2Ï¢wÅß×½ë¥xo/Kn(óg$~)¡À)éiÅBPÍM¬ Ë5gAr=M"«e)ë¤6B©nGc<Qíg á|ÎË%&þ	]îAwÿWßëáßßÿwLºØ¸LºMLºLºÌ¼Êì? ¯ ;Zwþ"ï¼k¢FJD%0±ùÐ®Bx9íx&òªx§ÍzrØwäÊ²¯¬{m±¼x[	}äÆ/¾öø= Ø+øïð¼$Ã>¡q;{öT
Wiªj¶¡^V¶´= 8ez/dÉË0¸­Ú\p¹daåÛvª<ÚwCVßn¦fÆçÝ&xO{FF.ÕUF6fÙ´êzZhØvÐ©p¶PTrpRMRÕíáÎÐ,Üà¾ÁÏ¨ë<Õëz Çm øFÝuêÎØÔØ1VWÛ
Ö]F°q~#,Ø¬¬À^hÎÙ¦mÞKJð¿CÿÆÊd0«µð¶j1±ÿe$Ö¹÷°hÐÿHls Pa*F© '}¡é¸§Ò¢)=}/¥Ô}éðN4hØ%{µåùgJQ;jh¹ãÉÏOýêÓØ²_eje»WBc¥ËëÄ8ø\Å¬#\ô1îXA¢@ê:%¤¹ð¯C®j8mëÇc³*FeÏ ¶twéE,Ò¿¹ .#W@Îl"îíâÜ¯¾Ë®Þà{¶ëC!;ïà"!Ws¥n@[éa"Ò/ø,qIëbrB8}löñ·o§£ïPôð¬ÅòrgV«E&6íÑfÒ't¬F+EàúuôPÇ2&á)·kÖª^/ô32K=}¢Ê}9éµR³àlà,C=}NEcBê*¦À8
b÷jÁ¼wEÖOd]{ü¯.ïß%àßßó¬LºÝÈ9LºÕKºLº:¸lÖ·´²f-\8TþöÓîNÄkÒå<BïmëÅL~ {Õ÷aÄ²yë¶Ó@5ømµÀðËÇqê]XiÉ´X1yÊÅBgõjøÂÇïm!\b®+ÿ?«#©òèÒr¸Aé:Á¿ôÂB²÷Y(²8bÅR8TõØx÷AúZRO>vÌR¸ËîÒ0ïK·![1õ±ç~j>ã¤Å7äDË~>mº»ô÷6?_®)5ÇËI)Å@%Ìùáµ1mn¶µÒBÄå/xp2%z7ÕYþÖL@ºÃ¾©Ó_LK2¸-»ÜüMfòBVC¥Ý×z¯Z×·jÚSà6úän¾¦ß*ðåÜ¹®¶
æÈÿ Bî1Tg^°fpavÇ0­¾¥¢<¦{Xa­ò{«¨	2Û³l§[]u® ÎÞå;ÿÃáA¬ÐñùvÖÐéu¶Q$Ol¾*B«ìu»Ú9ðÇO,ÅüÝª~¦ÖÇRÍeý¿Ë ÊAH¦4Å0¥ò»}Ñ©Âø%E®¸Ùa>[Ôic:¸SÙìäNÀürõ&ÄâØ¢±¯ÔpVT~W7Óxw[Óú%½¾hUÛ ¹Ð+×¨¢WñÐê|Èú×úÌ[Óñ$I÷¨=MA{9­æPu*¯%áhq«s]ó|E1Ë;ÿlvnÆªOµ3eÖÒD(tÄ­á5yªIpîÄ(>_láV6Ñ¬ pc){V4AÑD%X
RféÅ= 	çã+j3DÐð}0]%üâ¶®¶?Ï",Ü%jL9ÇÝ¯E·ÿü{ÃS/÷jm=MRÔWL¦iÙ«Óµ&CnàÅ°åKL§oë"%½Á?tðÎl²¦ã= kèvwAH?©ÑEóy »H-~÷RM{¶a¿uc9±E¤Òµ+MxìâK=MA*!iÁÌW4LfÙ6ZfÏ<ºà ñ&UXÑYòÈ^|×W®xB,­;óV J
;Ð¼Ãe úýö¼ø/ÍmÓöîã8FÇ¨¤=}eYÎ¢ªøÛ´f\Ðd,]khÐB©T^­´ÚòðªÈ= ûVéÃu'ïÈ ]ø+Ùï!S"§<ú©/[fÐkfQÀ­n¡a¸:ýèWyCvGýþh@J@ëº¤ÑE1ûmPÛó®ØaWM\*OQÂ<ñÐycE(ñ5ryx¡âÎó}*t0Ñ^Ó¡Ï§¼Ý¦z}^ÉÜFoÞd+^v¥¿ÐÈQ-ÆÒhëÙ4F¿vhÜÑqA7Ûúv­ÀÕ;©Q¨v­Â¤[5¦ÅÞHàf&õAÍ/§er$´ô09«×,öu¯ÔsxDätpT{b
gÉW¾É
²F:Q´ûô@¶±9Í³ÁÞm"2Êøû7.ª¼åìNÃRöyOÌM¡§xkJK 2tBa6P9ü¢Ìü«=MËÿ8òÖl<£EV=}úØK¬Çv@Oßk£ßß·´Lº-LºLìNºLºLºë%ãèw8¥öá=}äéð8gtcOéñÅ³C@åó7ã~^^!)bjQÕðAx%§&½$jX}ri aøjÏ*á(Ñ5)Q93i«û]vAk¢iHº=M,viërD>å,<8Y:CØU!uEQ¯fÇDÍ§RTg.Í©¿»ãäõ3;pÈRóÐÝ§ºCÕ3Ahcjêt¸<xvI	Íwé1E+Í6¤Îy	¾<´9l<®³·þ­|ÉÜ/<bbÊço¶Ã[\æè±!6êx9HÂ5zyv¹Kn³ WpíRcTPª¶Ä½U<õHÉÐNýÆÓÇR¯FÕç\=M´¦»_pêëoðC- ì0³Á8fð¶øÐ´÷pÐ¥WEOè®6y/=MJ©¶	2Åü§±ë® Ew¢³{¯äÅj7§áb\õ+£Ç>*í½i×5êPAn,eÞ¦åxSå¹ÑR2cÌg"Ð_ü+Ì¯}vnËpjOÿCâBüØ7Ì'¼(&]¸^kòØÎ{O)P%Jrùy=M·SoY¢dèÑKm
HM;TÝgúÍ»ýÈ­uÍ-Õ?ØîíIXÑ¦ò~}+éÕ!AöÒÅÙ8NÅØ¯´fe~SóÙÐfÛ/÷Ä&¬M ¸UïÓFÂß^Y~ÙrôöÓÙßqâÎìC­ýfæðgÔ© WTãRÝEÞæfïãd/ó9"0ýiT?÷Èj¢w	ö­zÅOdRÿaÙ¤ðG¨&Qq¶øòó¤g0«3kENZ¾N$òøõ¢Ñt÷¤uwæçAÁmäÐ+Û}H®Â8~{¼Ìè÷z±pþñ¨®,ÁÌ ºrøâ é!t[zaôÜä£ªl6²§m+ÆÙSùS¯ûs Ø¶ø«®«C¯Ý+YË÷jä!¸;­%Ú1,à»;u"m9=MÚRxÏv·³ÖÃÐ´~öòÒXßnªäæôQKD í9$ø/cÊz­Dö¿Op=M÷­=M %ó¨Õ1ÎvÁò>%ÂÕ8s{Þäôg³5ØIä@t[;6¨ýb	EmAÃ¶	¥s4Ï[áIï>4"q-Je³AÓuä¤TW|Â=MÔ+:0.xUâ "ùOÜ³_&(°ÆùHëGAÈ½Êrx<>zÐGÀÓõy":»¯©JÂmkLB|´ÔÌË´­¬·íÃVUo?º¨¡È|'ªSÐ>6ö±®7o¸,¡°MÃÝûí¿Pçï]ULLÂLÊyÌ¥úºLº¬ÊW1GÖt_È¾O3×eR¾¡ý\	ÎniRª>{¨ñk (8èbÎu?ªI(Óý'oÃ8´ÂWO#iõèÛw° $¿QHý»tEhx8±ÇlpÀ­ øhª .eÍø	u¨qR&u+B8ÑCý¦ (§ª>íí«5§2[.}äáX=}Å©ò=}= ä¦ó/s5'= é³0Ã¤B$eó°1CÔ3.
 £¥'¹esÏ¹k£*D=M)xhR4÷!éÔh	Ý)ÖM4Ý×igv	:3X3ìIzÐ>ùÆ-F¢³Ðý/&Srå¹÷Ê= Ytå#¨=}ü,©1pÚ:jlæÞdõn]Û¹Û ,t¹·­³ Îí©ùÉÑf=MåZTP×*=MtüÛ9nLnÔW@fBýÔ¸Y(þ,\	qÓ¸ÚvàÚìwM_[_àÖ÷ÿ­o^}øAGF§y	"ñ$kW]¼gÈÙ%£D÷ µw<¦kØ$­wÃOBã¢¥[·E¡¤VËO@(èuxÐÝîzz·sdãK¿k_v¨áÓÝõñX/'no !=}ëçÐ¹K¥®N«ÎIe2øÞ=MÆÄRé¬«8K-³ëêÕ<ÿ%ªaõsÞJ¨fu+u£»qzuk¸@$£æ
X8¼i¾5:rEld>	I¢ú@9}ìÞ,Ä®RÛMª:EÞL¦É"UûqÂ=}wüé¢UNÓbrÌ´@nÉùæ~¦ = Fí#=MS#ÃmÁ!&Iiû²hgª-K²T¡¢h¬Â|èÈ«0DFéÁ{XÔfêBí¿È¡¤/ö]ùU \
î¦t©-6Ë¶ÐÕdúæ{¼w°Ç%Æ1VýÂBÄm8dIÒoÀ òîóÛÇÈ}';Ñ#$¦ò²ë.¥Zp[©jô¥YÌNNýýÕ¥'µzÓ'N¥ÛÁ¢G^Ö§ftbgNÒÖbú\[°ÌÑDOþÖ>ØpÄÉ¦Àõ!6ÙÂh ÕÝËÒ@Pß6Íæ¯Gø_C$ß$âèø§, ÿ^õæÁ
gZ¶aw@÷#%MïÉ2bRw sEãÂ ãÐ ;3î@,)çB¥c±YsK/!Â"PÝ
ëÀÀSÄ¡/ní"ÔO³Öfômÿû¦~ç¹ü ÙÖçùa×Ba¤Õq6àpwÕ&qipî0KÓlÁX.ómzHYú¬GT%òe(BW¿ý"/:ë2µ¥ÑÙ$ø=MKMh¤S4û^jÂ|2ûlP;:ð.7ûÁ(nÆ×ã±ýO¤=M= i¹ã=}=M(ÃÆfhÇ¹p·$(»~£Nµ(·4PI@\Vr+Å[D' ¿-é174p!bG	m2XM}©¥Ñ3eÆðV
ìýuB=}òM²ÿ+ü
pëCNEÏ'w ±ëgCYrP¡+%*H~z$¬liä8ÃuCpzÓú¸Cç¨=M¨OMíôQGñÃ¯6q¢~+xªQ@=M*Rq¦ªzXêÒ¬-~ezØkªF"8¶ÆôÿZßá)©é÷9§Íºd£oñ°¼Á{$ðIô$¬Å¤{%w»ä«6¡âñ»)÷97©°Ú÷7v16<©Õ¤D±kLDG=MÀ@æÌ©
FSHäý6ïA> eév61
5¨è¦)ú
xéx44Pi·4´K[=}l*r9p<2"Îjù£»IHÀÛ9ñ=}´¶õÞm9µN¢È,üjÉÇ"C2ÎÉxÈ2n@.?×= x]ìwÓÿðj.líG£@pyÏÝ±£meyxÓN¬;ìHAx:ÇõN d^]M$VN
Ò9PkGDªL#ÌNÂk+ú¤0LgÜ½-Î UCÃ¹x÷ºm¸~ü± !æ¦Á§Úræ¦È1É#rèÞT °¤I´=Maqz2¼/Î
ú¨ÐkºbhEîªYÏx·ªÝÒIÖQv¹¨\·¦gMþé\+yµnÈÄ]õúÓÂy¶®µøâc<ü¿g°ßäâ;y'°Ô Mzë12g·{ 9Ý£
 ï|"òøÚÅÎ¬]S¸N$&G¡Rjðù
%W?s;ùIóÊhÜ~X_âßßÕLº¥KÊ¬LºLºLºÆ¸ø	ÖRçO¶ï/f_ã{º S2= .á:cªÃ=}, =}!	­ñKvo<cÞ£Bò0ng$KÎÁ KðigÇÙ4£wêX¤[»6+ÄAÙÍô0«ØNAÒ*}c5Ükz@²è6r[Û=M Áqq_syÔÓÇD¹[zÕ*~ÄÐî^<ûäDCJÿËßølö§ÇX¥·óøê]©·ËuR{ìÃ»üÿÆÔáí§p©ÜqÂÐgõ1oa{âôÃ>Ï ä$2ôs×&(¨!)i31Sq!êtÃZqÓsã	Ëd3Gù×¤fä	ýý/P$¤~ÞyØä´kIÒßöS,$lÓy=MìFêG7:>¢ÇÝùy®¶/CåZeV¾{PI8w>*¶Y9iÖ²A}ÄÀ=}:òëÙ"f~m£uÓ°°Amm·ýü®MÊ7Ò$&
z}/ýHÓ«ÍÑq<YÕ½³²Ýrý¤Ø{åÙµïÈ@¿ÑSâúÏ;OË= u%Ë%541p2kÓºA£W¤§y%éÈ+;­K(òNy÷°c[hö+·>y7ò§?EXUEukÂ=}JEµø¹E%§[l9G:©!A*ê&9·¡aÚcdðîö9÷ôL2
Ìf7·iÞt=}H5­ÞÁÔ·Ç3¯¥ ÙóÜL3~FB½=}úVòKc¹GH|ÌY¹¢­·ÌUí;ÒÙ|ün  íY3UrbBòü¹¿U  ÃdbA)ì±È0¥¨·µ-õkQ@r\{{Y¿Ã¯¤_j;Up§$¡!ö¶î~ËÁ§VöºüMuÆTzà»{ÈÛí8°VÒ9ÎÀ;õîª
XÇ¶°"èýÛÊÊ@¾2îC=}©&Ç)Y±»ªÃ@Þ³j×gvÜH=}ÞÑÁVÚs¾&!\[{|Ä¢-þyúµÖ0©¿j~ÍtÛ'Ùx½.O|~ìFÛÃWÁFO_¼¤áÃGù?Ü¿ß= $àEûçÿ-í¯Ô:_C:oAbð#µ'ª mKíAóÂªÿft È!³
üAXªï®ef§#f µdÞc¢ô!âIf8º«lÈ@NìÂñ§Êì³ðYn+cDKúðÀ§çÆm#yõÀÅ®ç{0ÆlQ5sòËxõD¬u$øÛ)
DkÐ÷È)¤ogp¥m¤%þk0
%Ï:kÆµzR¥È9-u=MP}.kS\{yFÂ'}£¸=M-&b?cÂþâÃïÿ%ß¹l8,LºLºLºLº]FPL= !äÍ,òÇ$g×3?ÍZà= §58.èpÜ,$÷J= g.C¤Lp$es×Ç'³|#ñ¼5){pÌh#væ©£ª
2«ÃMvª·2Ã{+Ö¶ªB
;­Ïo!ÅåéäÚ	³z¯\¡·
éÒ	(<0¸:!Ä2t\b3U­6¸&D¨,t¨¾3Ù²GEIs	 ±g;ÂÝAl¬æå¾´Ï*,	|m­éºÉþRQx-¢¡â|ê^S'ÈúKC/ ¢°å|5÷#IÁ a^åB²y£ì+å6Ø½½¤÷r
+Ñü8×¯©rYHÙõP	:³KNS¤zÄõ¥ðjUî5ÝWo¹F2,Êò&¹K=}IRÀ¬ªp]¸)Èo½U§=}­ KôÀ@ðZp"\íèNÛØÉÏhª8¬D\(v,<yíS¨¶Í-vJ6;Å\OH÷¾ÇP¦£ÙýdZZ[wÅRræÆÍÓÇô¢(õ~X\{ùZÚóùÎRWt.= BýÙ^\EígÈåþO4_?§¡_úZácúà|æË+÷Ñ:éèjeSKïV§´H pdçF¢Þëiâ_;æó$º·L¥DKºLºLºL=} -r#ÙÅ°EB ìúº¹·¡¥Å¤ËÁl>Kk­?JHP@r|î2Ìû¹?FÁH®Ëó'Ã¿]ýææhº7« Ó!æVÞ²Ù° ¨-AjXÉR±­¨-9.OÑCtrÇ-m¼V1Ðvr8<[
Î¡q;GËÁF>öpø=M¥LQPÐkjk®<'hNý7:ìM÷Ï>
§ã{Ò¹àl f¯zä¼ÓQÈ;ª,ÒUM%ÐQ2Anzó¶»YÎEF	îiWgQZ§þÄÀ@æîÒ%X£"É\ýU;Ö¯ÏfCHÉ¤ÂÐQ©*Âm=}½lÑ±DhvZSÍÄØæ°\ûÁº¦=}Öð÷ÈBÉþnVÚR´&VµÏÒ~;-A,üº×x³®µX]­NÖÒ×a~®ÜÛvÁÞ9_ÞÓß~yäW»øàNëÄ3_ÕnâcÞã§}§Q 5#aþ7nÿãøgÜ/oÚaë×ûN¹ïzjeç";ü<gz¢!³}þÁ«ÕïÍê 5çp0wm¡{óû:fYd(k«¢@Õ»íÒÕRw;HWj%Gc+Iò@ÐoçÊÅ#·Ä¾}hÝ(c^+¬	²o=}ö= ämõ÷:¥D= +ä-õÈ~:[DpÊq'ÎeYiKyÿñ=} QH'ËTpÎÝÜÃñvÑ(c(K/QpÇ¸:ÁÉhÙûs]"¼æèd«gÛZ¨4Ä^8ø6Nx·(|6©ëÿÄ«»Vêq«¬i¡8R"d·ýéÐé¸v¸Ö¡Ï6éIt4mt6Èô5øQr)vp	xö»¡8tòn4k>	öIí	¶±w²)°lå²U´'V#Íu¥qîù®qÊó¨ò:$Fk­Þn°¨'»íüÖ|§òüØvmw°6»åäI÷N@Ï À¨å5ù·Þ®IÏÜt cÌzó=MJQ½N±©F:rb+Ãø¶yKÑÉe(ªVnr7³¨DP$xo¤÷j6Ì["­­Ùªß'ô0ºL-zN
ºLºLºLý§X	cV£Û =M¤ðçªo|¹á}¯·ðáÅé«¸Ú³áéSlò37<Tpn§ Uæj{ qO§ÐbhÃ[QÍ'ÚÃñPÒ'«ÿ0h£-.!Nh<Âi=Mp7"¨8hÍîM[l±Á©ë®R+yu\óþòJe+°¡àxÍ6Co8Ù&E2Ad<¸ôÕs5·0.@|j¡§ðéLÆ³¼oÜg¡Êéf>
kÙ/x)k;	©Kq³1¸¹4¨'tvR3YL/hX#DÓTt4eÛ2Ø}#¢¬P% YùSlÚ|éì²Ç2BÎùl¾Úi=}µO}H+×­Ô+þjÉ£r+³(¶%"^|rSñ´èºÒÙs­ØÊÇëjEÿ§p¦¿,bìë[²ÿ<öb2¢ë®'¥?²b¹öìMOøkLñX78Drb,+QzýH1Ym¨ÏTöíwK±ÇHóÞMm¤ÂSõê9ÃK0h$2¦¡ÇEðkGª¡8B ÍT §jó>¤x©E5ýú{,Ùz¤üK!bK.8³½UzöKÙ½(Ï¥E¹>zhûFU'7³@4f¶¬ûùXíú£øÈ­Q7¹À²ýfAÆû¹¾V7Ù À)¢=M83	ÀñÀñc;ã=MY%Ìv­<Û=M¬Ö3ÆqÈªÖ=Mö¡;õÐGt´?n4uÒGÀY#SÔ7«µSn¦ªÎÏgP±BË,n£¥Ûi©£ÔÈ{­ÆM~	Ä\õ³ÒØ×³LÊ®xÅØ'Ê[¥ÎÒ¸Z­Æ¸~Î\QÝÖo ß/_5IúåcÓ_Ìâ)Öî§ÿ[=}|TàzÕäëö/Ö=}VàFÞåpërâü(ócVBºLÞLBU.kf·LºLºÎöpPói0v:@'HdûóÕ3GË?ì4W$ ;Ï?!r¢éZ=MC\ïØ0ÀEótá(3ÙD57'Y$tiì3Y68A{ÊÑH)qx	X5s¾1Êw)¢[1ÆRçþ,?1l38]õ±m¥ÙùpÌÉ:ù¨ÙI;ùEy%ÄùÎJ+0ÍAçZ>¢ZÐÞ>l0ÐTñ²ø~&MH|ùzÈÊ4Çj¯¥ÉË{òBt-|ünÈûÒÌp-mnÔÞÏñùk-N ±åZJ÷ûIõ©=Må\bÔ@åR&úë|H?´ÿÜ@böëU»çZBbÎ,5Hr¼90rô,µ¸¥£µ,ÖèúCÑV(~N5x¾@QÓ(}ª¢ýw»ZJ1Ó(WûjAD1£õªÊ9;KDÐ,'ø7ói¥Ð+jµª¹MGTÀ8j)Ñ'Ù¤ÁBózèLõðL©tØiü±,®XSz¼L¡Ln¸²Èz¦zKÛÜ>.fOK0¹;ØJ2}¢3í0Ë¢Î9í´yëÌËO§P×´¦ Þ/fµòü¡Æ«>ÈZ¢¤bíî®ÈÏÐHÝÊÏÿªØs=M«Ç±*ù=Mz[LÎ¶OhËÀ!CGþÌ[*Ò¤=M¶«¼Ä1Õwªdj=M<Í\À±ÜjªvÞ#[n9EÒ7¯68nÀ´ýÑ´­BwÅP YëÒG¡BÛCn¢ÒÓ§´Ñàn-Ù=}Ò÷Ú¯BÕún¾5%Ò8}¯F ù~¸\åôÑªÙÍ2p.ô~ônÇÆ2A®ÐFØS;Ér?b®µ<LmÙ[ÎÀu.Õú¾ÚsÚÄe!A µaãéèuô´ãfúçõ§aâmÿMN b= aä¦é]®öÃ:G$¯V~?Åè u*arVã~è}[ïÛWô"ÑpÃUù¨xKqüäÒ)(
*¹¶tóN=Mh¸0Q(v«s:^(¹qjÂ"E'iéP6*¡)ÍvK V(QÊ#X	XØ-AÝohù¯]óàä«¬üÏ>°_UÄá4êg°ÿHª_8|áÍùàÈb_õÜâ%íè·¿°_·êáQë¬ÍßÊþ¢Âßädá#°®Kº<ºLËÿºLºLºæÂXó.æÇ\¾ Û_î¯Ù&_9ÞêdçAé ñèV2èzêbÒç4içP©éé2ÊètyêÞTïµz/nÏÖ/@­7 ÎÀËÐQÀÔY Vç>îãÒ¨?^0GQ*Ö'§Þ9wÖ8×Ö D23KYAìÙ3ÍF5qÃ0Éõ5¥t5Õ65=}¶5A0Qè½T0U6åÓ6ë6El6õ-6õ¬6Å66%L6YÍ69û6©}6±>6!¾6Í2µ2Ù[2)ÞB#çB{iKëlLó+K*D«¨Cs«D£÷0¡'8 ·4¼/¾°«Gµ­Wù9ÔýÓIî-kQ.Å¬!ì½ÕKAÍí½ü|]>i½å»U1^IÛÄÓìÈi¿ûiÍ»nÆ[*É#'Ê£ªÁ«ÌÇCÀ
ÎÅ£ÊcMÁ[GÄ;ÎÇËF%&æD&Ð¦®ÊÆ·¨©X 8¼®èZ³¸W¹R¨ØP¢xU¾¨Ù«Û¥Ø¸XÏ²Þ+íßÍß]«LºÔDºÌ¹Í=MºLºLºÝXF±Õ¦zmípü®AùO{.Å{µ)=M&¶ám$üH©Y6Q{Àg>¾°B8Ê_$î&RkÌÎ·³ÐAÉ&mømIÒûüvåQ+¼¿7¬MnBª ¦ò \=M×>PÄwÕ×x²ú&l.m;ûÝÐíÈ÷½HK.Ùc}Ö¨ú±WDÑ¬Àr¶ofñ}D	Z´Ó{ÆH°£ÒFSZþÓpFêCÓÕýï»¢*%Zñ+Ók|ÅØº²YÆË.}ÐúXiÎÐ+ÇXU«rÂk¶$®J}^ÎWéÓF}4W¡^ÒÃÛÌÖ~¯aOuOÏ=MhÏ
ïïjïï	~ÏV ÀRÀHHÀQä@N4@(@W\,ò#* @À\ÀV@{çTÙçhæéîeéÒ&èÔ¦êç¦Eç]oQpOEx¯\ïJbXj/XÏS?fcç¦dÈdCöcD6cÓdôVâ&¡ËF!³¶¡_Ö¡®!¼þ¡ÝsóÞ
â"
Ö¡
XBAãÎ)ci4Õ3!2)E1åD2ÕÃ1Æ2±ó1Iö2åv1µs2=M4152A´5´6©5ù65Ù6%T5T6ZDE¿ÍöÛæäÏ@)0à¼_]1¿~ô§xö§:;=}:ë<³¾C»Û»û½k3#{kó[³ÛÞ'8Ø3Û1ØÏ%øÞ ¨Ï¿Þ³ÚÝ¦Çü¡çú¥wï½gú¸wô¬'ïªwý¶g}¯÷p£×
d°P|0rð
ÀÒ÷6Òúéøjùî*÷©÷"ª:ïòPD,BDüÂT\"BTB]ª_lðbpRßÊE+ËHËóÂ=}Â]%= %  %ÌÀ%¦0¥¥è¥a¨¥yH¥µx¥Í¥Ø =}CË8IK>@>L8F+¾Gë¾AÓ»M¸Ds½JC?#KI{@LÓF3GA[EûHkòÍúPýø}÷}ú=}ø0¾¹þeÅg OLºÌÕLºLºLºL|fÎÑÀ³®[ìÚnýÜéCÛ¾Ñæýä%cc-f¹%!$Å%Q¥m¦É¥}Ýe¡%CÓ[E#ÿfÐv°P0oðwcÐs0ðq°iyð°ÖEý±¹µ=}±SyUEU­ÖaÖÖÔNà¥7ÖÍîÓÝ %y@%xð%Ê0¥¿¥P¥è¥È(¥Ü¥fH%ox%£¸%{%qØ%d%¤%eMÎ1ñA¡LÝK½MMN-ËÌEÌåË9û)ü1þ!ýÒ|Â¥­r¥c²%%Ò%cj¥*¥Ñ
%J% ú%g:½Tº÷\¶O¾gÏ¯Ø§÷Ñ£Ó«×Ñ»7Ø±G×¹gÛµ·Ú­GÞ gÜ¨Ï¸GÜ´gÓ¼·×¢Ýª×ÓºÞùxagÂ $Â¿Á:ç	s'ó%ê
édögyp£§43ÐyÇû"[k¤õþÁgmÐ£j×H!Ppw#û+	Qöj2gGc1jvH#SAFYp÷s(¬)Eô*h?#b{AJ=MðnG}6Ë§óÏÎä¤É!ÁCðNôò(*gu¤©1ÁTHpG>-}3ïh
h¹t¤	ÁO4Ðy'6"³%µñºJj¦T[}§<>KÿåÓ[PW²£ÖzX´!Lá9h¨¤A^:P|W¹=}[Êÿ!Tñj<#eF0½"sÈ	ÓñtYj©\;>0~öÿ)åi¡Ñ)CÈ1ìïÐæi'b#o Á#{ø	Uëòjfj#®p 0K'%cþ
½Â£yÐA³ã°IÞ~ñ-õ>¼x}~	Ù+òôj££æV?÷ªÚEjSR£öN÷.3yAï»dÈpAWËõÐÖ½«Þª$ôÓ)¶Ô7Ä\¤ü]l5[Sê¶h©Ê¤þAb0ÛTªX]×ÉENðdÙmú,¸=Mm5#|Ì·Ä¦MðHn7ÉéÍôv<z\½Î¥Îö¨íg¬× P¨½]f$ÇAaj^³<ÙBAªR;ËP$-g¢Ã(P«tÄV6ÁÃé~ð;Ab*V-SÐ­ÚêT V»¶ÓÁ)=}ñº;ÉªAêP$STV<¸Aj*Q,ÛF¹}à¹aßé]£LºLºLºLºLº}¤SnZ"X&´
Õl£ÆðÁ+ÓÊÕqzÃ³ ®Ã4NYæÀÔ¯%á<S=MrÙmQrÓVjz´(îÃ(±¼-S¬Sñ×{j]h¢ñ=}rÈh¥{Üã°3v?ëögÛ«VlÊ£¯7¶?¶g£W-òÛØ²nü[ÕèR!Ç¶­eÍÄð°¾·
Ùh#ZÊ:Ç¨	MðÉ|ø±aHûÀÐ½~ÍÁ'Ó ý²tXûÆ°¹Tyyl;Æ~.9Oi±qK¿¾gÌ­$LÙf»Äþ|VKQ0rÍ+@òÆX"ç¼Vñé/zM+C¦®.\é2f=MkEðRÝ´d&äØ+êÙ= Ë¿ëÖØ#oþÝ~sÃÔG®ßo,ûÁîØÞùÑO£ 4ù²= ]kE*·§=}-QtæÀ= SÄ@h ±q|as	ÔG &Yw+@=M*8ª5ÕQs;ÀnW¨æÒ¾Nÿóðh-;ñrqSC Ø!(©0xù³ ,H$°l=}ÓBï¢÷¤7dÈ«Eýê8¡Q5eÔKAêº¸¨ýÕP_"ûÄ¬8­P= *;À	¶ ÙZ»Æ nW«ò}ÑkÆ¿ÝïN÷ß_ßóäÎ^»G¾¢jJwBkûZb\Ì»Áðïpo$ð4"÷îÚ¾,a¿à­¨ßßÇõv¬B·ÑÐN[ªªLzFL¸ÔJÐkSkKB§¹=MÚ¢ý7¨7ù÷~å¡Gµí÷R£üûâ¼rÜ þ=M {Ç?¯KÎÿO±àë{þ£Ëèä£àRwI¹èáÑíáÜ3?Õ©àÕ$ÿÃíRÌ¿?Og8eØ¾	 éþJ¢$ª¼@Ý ü£ªÜÀbñmÉðëØ· Ï3ÎèÏUk:ùéKO¤\òk{òÕ:Vïåm,d¹6¸Ïp.ð±ÀíË¿Bfbªs¡Ôr³Ö´)Çª¹GJ.VÓIíä÷Û°a*álôküc3|_-xfÓî$Í8G=}qè|SÃ ãºasKC#ÉV¯wÃxÄ!ÚºÐºbtRJL;ÃÄmÇÂnèÚ-ï½Núgôl¦:ÅÀÃU¶ójöczÏê¬-{ºÕÿÛ' *vEÂêÀÛLKK¢¾ÆO]B#]«,	»§Çþ1ï²mÿÁoã%nÙ«
eqÈ²A(·ïòHÜOæÓº!;' BHoËl,Í.p6L<ÃÔFôÌñ½ÌZ½lE¹SÔ>Çd Þ= ÒW±e¯ÅüBÈUPæü>Aºk9tK2 A,ây¸ÇZfrY;4Ñtw>¢¹Ë§E5<ª-ÕB
Q58ö£é9ëC³Â¸qRø®í@ú¤jD+ËÀÉüCd¼úx¡½«AÈy!õ¬ÕiZ{K£ðô5ñþÔõ´l&cHØ~-][Ñ(­¦Ï}æÏpXÂ×­ÄRØÉ¬ ÛeÞJÃe]WfHõ½TéÍ«ÁóÏå¤ÖM
f"{Û?)ûYð:®µñ@»,ÚH¤_y]AKödåÀ9-»áR¤´ AR0k?h%p¾[fÑJO+«ñ@ÅáP	Ýu§÷Mô*J¤p	øzp.³qD¨,Ñ³>úvÌöøP¥ßø¨¥¨þÅ§µ¼"ÃÉ\«bLv"	8ÊKÛÍrªíoZ½qù8ÄÔÁ.Q0j¶Isxsì®ù
{¬ô~)SüóRb±²F_an4í¬0µJ"sØ*BóÊ?ÑGÑÂ½àDÅÙC¤ÌÚHDrF= ñ7Âu±¿ÍR$%[1=Mµ5ÈÆ,³Ç¬üJÈºµ>¨N.<Ç.Z£Óò´å¦ÝÞÊJ
cAë¢þÍÍ­ý×ß'$|ð÷= È8a7ç^oÚ~Ò;hTÐ¸Ô£|¸Øÿ£2±õRØg mãq' lë§ nái@G½0%ä4³ü¡x4|Î¥VýyGüo¾ ö÷¹¾ÂGOË`});var h,o,a,l,c,u,d,U={a:{b:t=>Math.atan(t),a:t=>Math.cos(t),d:t=>Math.exp(t),e:t=>Math.log(t),f:(t,s)=>Math.pow(t,s),c:t=>Math.sin(t),h(t,s,e){r.copyWithin(t,s,s+e)},g(t){r.length,(t=>{throw"OOM"})()}}};this.u=s=>{t.u(ci,s)},this.U=()=>t.U(ci),this.instantiate=()=>(this.U().then((t=>WebAssembly.instantiate(t,U))).then((t=>{var e,i=t.exports;h=i.k,o=i.l,a=i.m,l=i.n,c=i.o,u=i.p,d=i.q,i.r,e=i.i.buffer,n=e,r=new Uint8Array(e),(t=>{t.j()})(i),s()})),this.ready=new Promise((t=>{s=t})).then((()=>{this.N=n,this.H=o,this.free=d,this.Js=h,this.Ws=a,this.Xs=l,this.Is=c,this.Zs=u})),this)}function ui(){return this.Fs=()=>(new this.Ys).instantiate(this.qs,this._s).then((t=>{this.te=t,this.se=this.te.S(this.ee,Uint8Array),this.ie=!0,this.re=this.te.S(1,Uint32Array),this.ne=this.te.S(1,Uint32Array),this.he=this.te.S(1,Uint32Array),this.Rs=this.te.S(1,Uint32Array),this.oe=this.te.S(1,Uint32Array),this.ae=this.te.S(256,Uint32Array),this.le=this.te.S(1,Int32Array),this.Ss=0,this.ce=0,this.ue=0,this.de=this.te.L.Js(this.se.K,this.re.K,this.ne.K,this.he.K,this.Rs.K,this.oe.K,this.ae.K,this.le.K,256)})),Object.defineProperty(this,"ready",{enumerable:!0,get:()=>this.Ue}),this.reset=()=>(this.free(),this.Fs()),this.free=()=>{this.te.L.Zs(this.de),this.te.free()},this.sendSetupHeader=t=>{this.se.G.set(t),this.re.G[0]=t.length,this.te.L.Ws(this.de,this.ie),this.ie=!1},this.initDsp=()=>{this.te.L.Xs(this.de)},this.decodePackets=t=>{let s=[],e=0,i=[];for(let r=0;r<t.length;r++){const n=t[r];this.se.G.set(n),this.re.G[0]=n.length,this.te.L.Is(this.de);const h=this.oe.G[0],o=[],a=new Uint32Array(this.te.L.N,this.ne.G[0],this.he.G[0]);for(let t=0;t<this.he.G[0];t++){const s=new Float32Array(h);s.set(new Float32Array(this.te.L.N,a[t],h)),o.push(s)}s.push(o),e+=h,this.Ss++,this.ce+=n.length,this.ue+=h;for(let t=0;t<this.le.G;t+=2)i.push({message:this.te.V(this.ae.G[t])+" "+this.te.V(this.ae.G[t+1]),frameLength:n.length,frameNumber:this.Ss,inputBytes:this.ce,outputSamples:this.ue});this.le.G[0]=0}return this.Ys.T(i,s,this.he.G[0],e,this.Rs.G[0],16)},this.fe=ui.Z,this.Ys=ui.W||e,this.qs=ui.X||ci,this._s=ui.I,this.ee=131072,this.Ue=this.Fs(),this}const di=Symbol();class Ui{constructor(){this.os=t=>{if("vorbis"!==t)throw Error("@wasm-audio-decoders/ogg-vorbis does not support this codec "+t)},new e,this.Fs(),this[di](ui)}Fs(){this.pe=!0,this.yt=new ri("audio/ogg",{gs:this.os,Ps:!1})}[di](t){if(this.de){const t=this.de;t.ready.then((()=>t.free()))}this.de=new t,this.Ue=this.de.ready}get ready(){return this.Ue}async reset(){return this.Fs(),this.de.reset()}free(){this.de.free()}async ye(t){const s=[];for(let e=0;e<t.length;e++){const i=t[e];if(this.pe&&(1===i[hi][0]&&this.de.sendSetupHeader(i[hi]),i[ni].length)){const t=i[ni][0][oi];this.de.sendSetupHeader(t[ai]),this.de.sendSetupHeader(t[li]),this.de.initDsp(),this.pe=!1}s.push(...i[ni].map((t=>t[hi])))}return this.de.decodePackets(s)}async decode(t){return this.ye([...this.yt.vs(t)])}async flush(){const t=this.ye([...this.yt.flush()]);return await this.reset(),t}async decodeFile(t){const s=this.ye([...this.yt.parseAll(t)]);return await this.reset(),s}}class fi extends i{constructor(t){super(t,"ogg-vorbis-decoder",ui,ci)}async sendSetupHeader(t){return this._("sendSetupHeader",t)}async initDsp(){return this._("initDsp")}async decodePackets(t){return this._("decodePackets",t)}}class pi extends Ui{constructor(){super(),super[di](fi)}async free(){super.free()}terminate(){this.de.terminate()}}r(Ui,"OggVorbisDecoder"),r(pi,"OggVorbisDecoderWebWorker"),t.OggVorbisDecoder=Ui,t.OggVorbisDecoderWebWorker=pi},"object"==typeof exports&&"undefined"!=typeof module?s(exports,require("@eshaz/web-worker")):"function"==typeof define&&define.amd?define(["exports","@eshaz/web-worker"],s):s((t="undefined"!=typeof globalThis?globalThis:t||self)["ogg-vorbis-decoder"]={},t.Worker);
//# sourceMappingURL=ogg-vorbis-decoder.min.js.map